/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.ssl;

import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509TrustManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EasyX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Log LOG = LogFactory.getLog(EasyX509TrustManager.class);

    public EasyX509TrustManager(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)"SunX509");
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length == 0) {
            throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
        }
        this.standardTrustManager = (X509TrustManager)trustManagerArray[0];
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
        return this.standardTrustManager.isClientTrusted(x509CertificateArray);
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray != null && LOG.isDebugEnabled()) {
            LOG.debug("Server certificate chain:");
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                LOG.debug("X509Certificate[" + i + "]=" + x509CertificateArray[i]);
            }
        }
        if (x509CertificateArray != null && x509CertificateArray.length == 1) {
            X509Certificate x509Certificate = x509CertificateArray[0];
            try {
                x509Certificate.checkValidity();
            }
            catch (CertificateException certificateException) {
                LOG.error(certificateException.toString());
                return false;
            }
            return true;
        }
        return this.standardTrustManager.isServerTrusted(x509CertificateArray);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

