/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue.dev;

import com.google.appengine.api.labs.taskqueue.TaskQueuePb;
import com.google.appengine.api.labs.taskqueue.dev.QueueStateInfo;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.QueueXml;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevQueue {
    static final int DEFAULT_BUCKET_SIZE = 5;
    private final QueueXml.Entry entry;
    private final Map<String, Task> tasksByName = new HashMap<String, Task>();
    private final AtomicInteger taskNameGenerator;

    DevQueue(QueueXml.Entry entry, AtomicInteger taskNameGenerator) {
        this.taskNameGenerator = taskNameGenerator;
        this.entry = entry;
    }

    private String genTaskName() {
        Integer newId = this.taskNameGenerator.incrementAndGet();
        return "task" + newId.toString();
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    synchronized TaskQueuePb.TaskQueueAddResponse add(TaskQueuePb.TaskQueueAddRequest addRequest) {
        Task task = new Task(addRequest);
        TaskQueuePb.TaskQueueAddResponse addResponse = new TaskQueuePb.TaskQueueAddResponse();
        if (addRequest.hasTaskName() && !addRequest.getTaskName().equals("")) {
            return addResponse;
        }
        addResponse.setChosenTaskName(task.getTaskName());
        return addResponse;
    }

    protected synchronized Map<String, Task> getTasksByName() {
        return new HashMap<String, Task>(this.tasksByName);
    }

    protected String getQueueName() {
        return this.entry.getName();
    }

    protected QueueXml.Entry getEntry() {
        return this.entry;
    }

    QueueStateInfo getStateInfo() {
        Map<String, Task> map = this.getTasksByName();
        ArrayList<Task> taskList = new ArrayList<Task>(map.values());
        ArrayList<QueueStateInfo.TaskStateInfo> taskInfoList = new ArrayList<QueueStateInfo.TaskStateInfo>();
        for (Task task : taskList) {
            taskInfoList.add(new QueueStateInfo.TaskStateInfo(task.getTaskName(), task.getEtaMillis(), task.getAddRequest()));
        }
        Collections.sort(taskInfoList, new Comparator<QueueStateInfo.TaskStateInfo>(){

            @Override
            public int compare(QueueStateInfo.TaskStateInfo t1, QueueStateInfo.TaskStateInfo t2) {
                return Long.valueOf(t1.getEtaMillis()).compareTo(t2.getEtaMillis());
            }
        });
        return new QueueStateInfo(this.entry, taskInfoList);
    }

    synchronized boolean deleteTask(String taskName) {
        return this.tasksByName.remove(taskName) != null;
    }

    class Task {
        private final String taskName;
        private final TaskQueuePb.TaskQueueAddRequest addRequest;
        private long etaMillis;

        Task(TaskQueuePb.TaskQueueAddRequest addRequest) {
            Task duplicateTask;
            String tmpTaskName;
            this.addRequest = addRequest;
            if (addRequest.hasTaskName() && !addRequest.getTaskName().equals("")) {
                tmpTaskName = addRequest.getTaskName();
                duplicateTask = (Task)DevQueue.this.tasksByName.get(tmpTaskName);
            } else {
                do {
                    tmpTaskName = DevQueue.this.genTaskName();
                } while ((duplicateTask = (Task)DevQueue.this.tasksByName.get(tmpTaskName)) != null);
            }
            this.taskName = tmpTaskName;
            if (duplicateTask != null) {
                throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.TASK_ALREADY_EXISTS.getValue());
            }
            this.etaMillis = addRequest.getEtaUsec() / 1000L;
            long currentTimeMillis = DevQueue.this.currentTimeMillis();
            if (currentTimeMillis > this.etaMillis) {
                this.etaMillis = currentTimeMillis;
            }
            DevQueue.this.tasksByName.put(tmpTaskName, this);
        }

        public String getTaskName() {
            return this.taskName;
        }

        public TaskQueuePb.TaskQueueAddRequest getAddRequest() {
            return this.addRequest;
        }

        public long getEtaMillis() {
            return this.etaMillis;
        }
    }
}

