/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.QueryResultsSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryIterator
implements Iterator<Entity> {
    private final QueryResultsSource resultsSource;
    private final LinkedList<Entity> entityBuffer;
    private final int minRequestSize;

    QueryIterator(QueryResultsSource resultsSource) {
        this(resultsSource, 10);
    }

    QueryIterator(QueryResultsSource resultsSource, int minRequestSize) {
        this.resultsSource = resultsSource;
        this.minRequestSize = minRequestSize;
        this.entityBuffer = new LinkedList();
    }

    @Override
    public boolean hasNext() {
        return this.ensureLoaded(1);
    }

    @Override
    public Entity next() {
        if (this.ensureLoaded(1)) {
            return this.entityBuffer.removeFirst();
        }
        throw new NoSuchElementException();
    }

    public List<Entity> nextList(int maximumElements) {
        this.ensureLoaded(maximumElements);
        int numberToReturn = Math.min(maximumElements, this.entityBuffer.size());
        List backingList = this.entityBuffer.subList(0, numberToReturn);
        ArrayList<Entity> returnList = new ArrayList<Entity>(backingList);
        backingList.clear();
        return returnList;
    }

    private boolean ensureLoaded(int numberDesired) {
        int numberToLoad = numberDesired - this.entityBuffer.size();
        if (numberToLoad > 0 && !this.resultsSource.hasMoreEntities()) {
            if (numberToLoad < this.minRequestSize) {
                numberToLoad = this.minRequestSize;
            }
            this.entityBuffer.addAll(this.resultsSource.getMoreEntities(numberToLoad));
        }
        return this.entityBuffer.size() >= numberDesired;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

