/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.api;

import java.util.Map;

public class ApiProxy {
    private static final ThreadLocal<Environment> environmentThreadLocal = new ThreadLocal();
    private static Delegate delegate;

    private ApiProxy() {
    }

    public static byte[] makeSyncCall(String packageName, String methodName, byte[] request) throws ApiProxyException {
        Environment env = ApiProxy.getCurrentEnvironment();
        if (delegate == null || env == null) {
            throw new CallNotFoundException(packageName, methodName);
        }
        return delegate.makeSyncCall(env, packageName, methodName, request);
    }

    public static void log(LogRecord record) {
        if (delegate != null) {
            delegate.log(ApiProxy.getCurrentEnvironment(), record);
        }
    }

    public static Environment getCurrentEnvironment() {
        return environmentThreadLocal.get();
    }

    public static void setDelegate(Delegate aDelegate) {
        delegate = aDelegate;
    }

    public static Delegate getDelegate() {
        return delegate;
    }

    public static void setEnvironmentForCurrentThread(Environment environment) {
        environmentThreadLocal.set(environment);
    }

    public static void clearEnvironmentForCurrentThread() {
        environmentThreadLocal.set(null);
    }

    public static class UnknownException
    extends ApiProxyException {
        public UnknownException(String packageName, String methodName, Throwable nestedException) {
            super("An error occurred for the API request %s.%s().", packageName, methodName, nestedException);
        }

        public UnknownException(String packageName, String methodName) {
            super("An error occurred for the API request %s.%s().", packageName, methodName);
        }

        public UnknownException(String message) {
            super(message);
        }
    }

    public static class RequestTooLargeException
    extends ApiProxyException {
        public RequestTooLargeException(String packageName, String methodName) {
            super("The request to API call %s.%s() was too large.", packageName, methodName);
        }
    }

    public static class OverQuotaException
    extends ApiProxyException {
        public OverQuotaException(String packageName, String methodName) {
            super("The API call %s.%s() required more quota than is unavailable.", packageName, methodName);
        }
    }

    public static class CapabilityDisabledException
    extends ApiProxyException {
        public CapabilityDisabledException(String packageName, String methodName) {
            super("The API call %s.%s() is temporarily unavailable.", packageName, methodName);
        }
    }

    public static class CancelledException
    extends ApiProxyException {
        public CancelledException(String packageName, String methodName) {
            super("The API call %s.%s() was explicitly cancelled.", packageName, methodName);
        }
    }

    public static class ApiDeadlineExceededException
    extends ApiProxyException {
        public ApiDeadlineExceededException(String packageName, String methodName) {
            super("The API call %s.%s() took too long to respond and was cancelled.", packageName, methodName);
        }
    }

    public static class ArgumentException
    extends ApiProxyException {
        public ArgumentException(String packageName, String methodName) {
            super("An error occurred parsing (locally or remotely) the arguments to %S.%s().", packageName, methodName);
        }
    }

    public static class CallNotFoundException
    extends ApiProxyException {
        public CallNotFoundException(String packageName, String methodName) {
            super("The API package '%s' or call '%s()' was not found.", packageName, methodName);
        }
    }

    public static class RPCFailedException
    extends ApiProxyException {
        public RPCFailedException(String packageName, String methodName) {
            super("The remote RPC to the application server failed for the call %s.%s().", packageName, methodName);
        }
    }

    public static class ApplicationException
    extends ApiProxyException {
        private final int applicationError;
        private final String errorDetail;

        public ApplicationException(int applicationError) {
            this(applicationError, "");
        }

        public ApplicationException(int applicationError, String errorDetail) {
            super("ApplicationError: " + applicationError + ": " + errorDetail);
            this.applicationError = applicationError;
            this.errorDetail = errorDetail;
        }

        public int getApplicationError() {
            return this.applicationError;
        }

        public String getErrorDetail() {
            return this.errorDetail;
        }
    }

    public static class ApiProxyException
    extends RuntimeException {
        public ApiProxyException(String message, String packageName, String methodName) {
            this(String.format(message, packageName, methodName));
        }

        private ApiProxyException(String message, String packageName, String methodName, Throwable nestedException) {
            super(String.format(message, packageName, methodName), nestedException);
        }

        public ApiProxyException(String message) {
            super(message);
        }
    }

    public static final class LogRecord {
        private final Level level;
        private final long timestamp;
        private final String message;

        public LogRecord(Level level, long timestamp, String message) {
            this.level = level;
            this.timestamp = timestamp;
            this.message = message;
        }

        public Level getLevel() {
            return this.level;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getMessage() {
            return this.message;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Level {
            debug,
            info,
            warn,
            error,
            fatal;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Delegate<E extends Environment> {
        public byte[] makeSyncCall(E var1, String var2, String var3, byte[] var4) throws ApiProxyException;

        public void log(E var1, LogRecord var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Environment {
        public String getAppId();

        public String getVersionId();

        public String getEmail();

        public boolean isLoggedIn();

        public boolean isAdmin();

        public String getAuthDomain();

        public String getRequestNamespace();

        public Map<String, Object> getAttributes();
    }
}

