/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.HttpLogWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;

public class GwsLogWriter
extends HttpLogWriter {
    private final String GWS_LOG_DATE_FORMAT = "[dd/MMM/yyyy:HH:mm:ss]";

    public GwsLogWriter(String basename, int port, int logRotateBytes) throws IOException {
        super(basename, port, logRotateBytes, TimeZone.getTimeZone("America/Los_Angeles"));
        this.setLogDateFormat("[dd/MMM/yyyy:HH:mm:ss]");
    }

    public GwsLogWriter(String basename, int port) throws IOException {
        this(basename, port, 524288000);
    }

    public GwsLogWriter(OutputStream outStream) {
        super(outStream);
        this.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
        this.setLogDateFormat("[dd/MMM/yyyy:HH:mm:ss]");
    }

    public String generateLogLine(Entry e) {
        StringBuilder sb = new StringBuilder(160);
        sb.append(this.getLogDateFormat().format(new Date(e.time)));
        sb.append(' ');
        sb.append(e.time / 1000L);
        sb.append('\t');
        GwsLogWriter.appendField(sb, e.request);
        sb.append('\t');
        GwsLogWriter.appendField(sb, e.originatingHost);
        sb.append('\t');
        sb.append(e.responseCode);
        sb.append('\t');
        sb.append(e.responseBytes);
        sb.append('\t');
        sb.append(e.numResults);
        sb.append('\t');
        GwsLogWriter.appendField(sb, e.referer);
        sb.append('\t');
        GwsLogWriter.appendField(sb, e.userAgent);
        sb.append('\t');
        GwsLogWriter.appendField(sb, e.httpHost);
        sb.append('\t');
        GwsLogWriter.appendField(sb, e.cookies);
        sb.append('\t');
        GwsLogWriter.appendField(sb, e.timing);
        sb.append(' ');
        sb.append('\t');
        GwsLogWriter.appendField(sb, e.displayLanguage);
        sb.append(' ');
        GwsLogWriter.appendField(sb, e.acceptLanguage);
        sb.append('\t');
        GwsLogWriter.appendField(sb, e.headerOrder);
        sb.append('\t');
        GwsLogWriter.appendField(sb, e.experimentLabel);
        sb.append('\t');
        GwsLogWriter.appendField(sb, e.impressions);
        if (e.requestId != 0L) {
            sb.append('\t');
            sb.append('\t');
            sb.append('\t');
            sb.append('\t');
            sb.append(e.requestId);
        }
        sb.append('\n');
        return sb.toString();
    }

    public String generateLogLine(HttpLogWriter.Entry e) {
        Entry glwe = e instanceof Entry ? (Entry)e : new Entry(e);
        return this.generateLogLine(glwe);
    }

    public void log(Entry e) throws IOException {
        this.log(this.generateLogLine(e));
    }

    public static Entry createEntry(HttpServletRequest req) {
        return new Entry(HttpLogWriter.createEntry(req, req.getQueryString()));
    }

    public static Entry createEntry(HttpServletRequest req, String queryString) {
        return new Entry(HttpLogWriter.createEntry(req, queryString));
    }

    public static class Entry
    extends HttpLogWriter.Entry {
        public int numResults = 0;
        public String displayLanguage = "en";
        public String headerOrder;
        public String experimentLabel;
        public String impressions = "0";
        public long requestId = 0L;

        public Entry(HttpLogWriter.Entry e) {
            super(e);
            this.numResults = 0;
            this.headerOrder = null;
            this.experimentLabel = null;
            this.impressions = "0";
            this.requestId = 0L;
            this.displayLanguage = "en";
        }

        public Entry() {
        }
    }
}

