/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.Throwables;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;

public class GoogleException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_EXTERNAL_MESSAGE = "A system error has occurred";
    private String internalMessage;
    private String externalMessage = "A system error has occurred";

    public GoogleException() {
    }

    public GoogleException(Throwable t) {
        super(t);
        this.setInternalMessage(GoogleException.getStackTrace(t));
    }

    public GoogleException(Throwable t, String externalMessage) {
        super(externalMessage, t);
        this.setInternalMessage(GoogleException.getStackTrace(t));
        this.setExternalMessage(externalMessage);
    }

    public GoogleException(String internalMessage) {
        super(internalMessage);
        this.setInternalMessage(internalMessage);
    }

    public GoogleException(String internalMessage, String externalMessage) {
        super(internalMessage);
        this.setInternalMessage(internalMessage);
        this.setExternalMessage(externalMessage);
    }

    public int getErrorCode() {
        return -999;
    }

    public String getInternalMessage() {
        return this.internalMessage;
    }

    public void setInternalMessage(String s) {
        this.internalMessage = s;
    }

    public String getExternalMessage() {
        return this.externalMessage;
    }

    public void setExternalMessage(String s) {
        this.externalMessage = s;
    }

    public String getMessage() {
        return this.getInternalMessage();
    }

    public String getEmailRecipients() {
        return null;
    }

    @Deprecated
    public static String getStackTrace(Throwable t) {
        return Throwables.getStackTraceAsString(t);
    }

    public static String exceptionToVerboseString(Throwable e) {
        Throwable root;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (e instanceof ServletException && (root = ((ServletException)e).getRootCause()) != null) {
            pw.println(GoogleException.exceptionToVerboseString(root));
        }
        e.printStackTrace(pw);
        return sw.toString();
    }
}

