/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.jetty;

import java.util.logging.Level;
import org.mortbay.log.Logger;

public class JettyLogger
implements Logger {
    private final java.util.logging.Logger logger;

    public JettyLogger() {
        this(null);
    }

    public JettyLogger(String name) {
        String logName = "JettyLogger(" + name + ")";
        this.logger = java.util.logging.Logger.getLogger(logName);
    }

    public boolean isDebugEnabled() {
        return this.logger.getLevel() == Level.FINEST;
    }

    public void setDebugEnabled(boolean enabled) {
        this.logger.setLevel(enabled ? Level.FINEST : Level.INFO);
    }

    public void info(String msg, Object arg0, Object arg1) {
        this.logger.info(this.format(msg, arg0, arg1));
    }

    public void debug(String msg, Throwable th) {
        this.logger.log(Level.FINE, msg, th);
    }

    public void debug(String msg, Object arg0, Object arg1) {
        this.logger.fine(this.format(msg, arg0, arg1));
    }

    public void warn(String msg, Object arg0, Object arg1) {
        this.logger.warning(this.format(msg, arg0, arg1));
    }

    public void warn(String msg, Throwable th) {
        this.logger.log(Level.WARNING, msg, th);
    }

    private String format(String msg, Object arg0, Object arg1) {
        int i1;
        int i0 = msg.indexOf("{}");
        int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
        if (arg1 != null && i1 >= 0) {
            msg = msg.substring(0, i1) + arg1 + msg.substring(i1 + 2);
        }
        if (arg0 != null && i0 >= 0) {
            msg = msg.substring(0, i0) + arg0 + msg.substring(i0 + 2);
        }
        return msg;
    }

    public Logger getLogger(String name) {
        return new JettyLogger(name);
    }

    public String toString() {
        return this.logger.getName();
    }
}

