/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.RequestParameters;
import com.google.inject.servlet.RequestScoped;
import com.google.inject.servlet.ServletScopes;
import com.google.inject.servlet.SessionScoped;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ServletModule
extends AbstractModule {
    protected void configure() {
        this.bindScope(RequestScoped.class, ServletScopes.REQUEST);
        this.bindScope(SessionScoped.class, ServletScopes.SESSION);
        Provider<HttpServletRequest> requestProvider = new Provider<HttpServletRequest>(){

            public HttpServletRequest get() {
                return GuiceFilter.getRequest();
            }

            public String toString() {
                return "RequestProvider";
            }
        };
        this.bind(HttpServletRequest.class).toProvider((Provider)requestProvider);
        this.bind(ServletRequest.class).toProvider((Provider)requestProvider);
        Provider<HttpServletResponse> responseProvider = new Provider<HttpServletResponse>(){

            public HttpServletResponse get() {
                return GuiceFilter.getResponse();
            }

            public String toString() {
                return "ResponseProvider";
            }
        };
        this.bind(HttpServletResponse.class).toProvider((Provider)responseProvider);
        this.bind(ServletResponse.class).toProvider((Provider)responseProvider);
        this.bind(HttpSession.class).toProvider((Provider)new Provider<HttpSession>(){

            public HttpSession get() {
                return GuiceFilter.getRequest().getSession();
            }

            public String toString() {
                return "SessionProvider";
            }
        });
        this.bind((TypeLiteral)new TypeLiteral<Map<String, String[]>>(){}).annotatedWith(RequestParameters.class).toProvider((Provider)new Provider<Map<String, String[]>>(){

            public Map<String, String[]> get() {
                return GuiceFilter.getRequest().getParameterMap();
            }

            public String toString() {
                return "RequestParametersProvider";
            }
        });
    }
}

