/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.Speed;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.ReturnedCookie;
import org.openqa.selenium.safari.AppleScript;
import org.openqa.selenium.safari.SafariWebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafariDriver
implements WebDriver,
FindsByLinkText,
FindsById,
FindsByXPath,
SearchContext {
    protected static final String ELEMENTS = "document.webdriverElements";
    private AppleScript appleScript = new AppleScript();

    public SafariDriver() {
        this.appleScript.executeApplescript("tell application \"Safari\"\ractivate\rend tell");
        this.appleScript.executeJavascript("if (!document.webdriverElements) { document.webdriverElements = new Array(); }");
    }

    public void get(String url) {
        this.appleScript.executeApplescript("tell application \"Safari\"\rset URL in document 1 to \"" + url + "\"\rend tell");
        this.waitForLoadToComplete();
    }

    public String getCurrentUrl() {
        return this.appleScript.executeJavascript("return document.location");
    }

    public String getTitle() {
        return this.appleScript.executeJavascript("return document.title");
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public String getPageSource() {
        throw new UnsupportedOperationException("getPageSource");
    }

    public void close() {
        throw new UnsupportedOperationException("close");
    }

    public void quit() {
        this.appleScript.executeApplescript("tell application \"Safari\" to quit");
    }

    public Set<String> getWindowHandles() {
        throw new UnsupportedOperationException("getWindowHandles");
    }

    public String getWindowHandle() {
        throw new UnsupportedOperationException("getWindowHandle");
    }

    public WebDriver.TargetLocator switchTo() {
        throw new UnsupportedOperationException("switchTo");
    }

    public WebDriver.Navigation navigate() {
        throw new UnsupportedOperationException("navigate");
    }

    public WebDriver.Options manage() {
        return new SafariOptions();
    }

    public void waitForLoadToComplete() {
        while (!"complete".equals(this.appleScript.executeJavascript("return document.readyState"))) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public WebElement findElementByLinkText(String using) {
        String res = this.appleScript.executeJavascript("for (var i = 0; i < document.links.length; i++) {\r  var element = document.links[i];\r  if (element.text == '" + using + "') {\r" + this.addToElements() + "  }\r" + "} return \"No element found\";");
        if (!"No element found".equals(res)) {
            return new SafariWebElement(this, res);
        }
        throw new NoSuchElementException("Cannot find element with link text: " + using);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        throw new UnsupportedOperationException("findElementsByLinkText");
    }

    public WebElement findElementById(String using) {
        String id = this.appleScript.executeJavascript("var element = document.getElementById(\"" + using + "\");" + this.addToElements());
        if (!"No element found".equals(id)) {
            return new SafariWebElement(this, id);
        }
        throw new NoSuchElementException("Cannot find element with id: " + using);
    }

    public List<WebElement> findElementsById(String using) {
        throw new UnsupportedOperationException("findElementsById");
    }

    public WebElement findElementByXPath(String using) {
        String result = this.appleScript.executeJavascript("var element = document.evaluate(\"" + using + "\", document, null, XPathResult.FIRST_ORDERED_NODE_TYPE,  null).singleNodeValue;\r" + this.addToElements());
        if (!"No element found".equals(result)) {
            return new SafariWebElement(this, result);
        }
        throw new NoSuchElementException("Cannot find element using xpath: " + using);
    }

    public List<WebElement> findElementsByXPath(String using) {
        String result = this.appleScript.executeJavascript("var result = document.evaluate(\"" + using + "\", document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE,  null).singleNodeValue;\r" + "var elements = new Array();\r" + "var element = result.iterateNext();\r" + "while (element) {" + "  elements.push(element);\r" + "  element = result.iterateNext();\r" + "}\r" + this.addManyElements());
        String[] ids = result.split(" ");
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
        for (String id : ids) {
            toReturn.add(new SafariWebElement(this, id));
        }
        return toReturn;
    }

    public List<WebElement> findElementsByClassName(String using) {
        throw new UnsupportedOperationException("findElementsByClassName");
    }

    public WebElement findElementByClassName(String using) {
        throw new UnsupportedOperationException("findElementByClassName");
    }

    private String addToElements() {
        return "if (element) {     if (!document.webdriverElements)\r      document.webdriverElements = new Array();\r    return document.webdriverElements.push(element) - 1;\r} return \"No element found\"";
    }

    private String addManyElements() {
        return "var toReturn = \"\"\rfor (var i = 0; i < elements.length; i++) {\r  toReturn += (document.webdriverElements.push(elements[i]) - 1) + \" \"\r}\rreturn toReturn;";
    }

    public WebElement findElementByPartialLinkText(String using) {
        throw new UnsupportedOperationException();
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SafariOptions
    implements WebDriver.Options {
        private SafariOptions() {
        }

        public void addCookie(Cookie cookie) {
            SafariDriver.this.appleScript.executeJavascript("document.cookie = \"" + cookie.toString() + "\"");
        }

        public void deleteCookieNamed(String name) {
            this.deleteCookie((Cookie)new ReturnedCookie(name, "", this.getCurrentHost(), "", null, false));
        }

        public void deleteCookie(Cookie cookie) {
            Date dateInPast = new Date(0L);
            ReturnedCookie toDelete = new ReturnedCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), dateInPast, false);
            this.addCookie((Cookie)toDelete);
        }

        public void deleteAllCookies() {
            Set<Cookie> cookies = this.getCookies();
            for (Cookie cookie : cookies) {
                this.deleteCookie(cookie);
            }
        }

        public Set<Cookie> getCookies() {
            String[] cookies;
            String currentUrl = this.getCurrentHost();
            HashSet<Cookie> toReturn = new HashSet<Cookie>();
            String allDomainCookies = SafariDriver.this.appleScript.executeJavascript("return document.cookie");
            for (String cookie : cookies = allDomainCookies.split("; ")) {
                String[] parts = cookie.split("=");
                if (parts.length != 2) continue;
                toReturn.add((Cookie)new ReturnedCookie(parts[0], parts[1], currentUrl, "", null, false));
            }
            return toReturn;
        }

        public Speed getSpeed() {
            throw new UnsupportedOperationException("getMouseSpeed");
        }

        public void setSpeed(Speed speed) {
            throw new UnsupportedOperationException("setMouseSpeed");
        }

        private String getCurrentHost() {
            try {
                URL url = new URL(SafariDriver.this.getCurrentUrl());
                return url.getHost();
            }
            catch (MalformedURLException e) {
                return "";
            }
        }
    }
}

