/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.servlet.GuiceFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ServletScopes {
    public static final Scope REQUEST = new Scope(){

        public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
            final String name = key.toString();
            return new Provider<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public T get() {
                    HttpServletRequest request;
                    HttpServletRequest httpServletRequest = request = GuiceFilter.getRequest();
                    synchronized (httpServletRequest) {
                        Object t = request.getAttribute(name);
                        if (t == null) {
                            t = creator.get();
                            request.setAttribute(name, t);
                        }
                        return t;
                    }
                }
            };
        }

        public String toString() {
            return "ServletScopes.REQUEST";
        }
    };
    public static final Scope SESSION = new Scope(){

        public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
            final String name = key.toString();
            return new Provider<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public T get() {
                    HttpSession session;
                    HttpSession httpSession = session = GuiceFilter.getRequest().getSession();
                    synchronized (httpSession) {
                        Object t = session.getAttribute(name);
                        if (t == null) {
                            t = creator.get();
                            session.setAttribute(name, t);
                        }
                        return t;
                    }
                }
            };
        }

        public String toString() {
            return "ServletScopes.SESSION";
        }
    };

    private ServletScopes() {
    }
}

