package jp.ne.motoki.android.fuelchecker;

import java.text.DateFormat;
import java.util.Calendar;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.app.TimePickerDialog;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.DatePicker;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.Toast;

public class FuelCheckerActivity extends Activity {
    
    private static final String TAG = "FuelChecker";
    
    // TODO P[ύX\l
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(DateFormat.MEDIUM);
    private static final DateFormat TIME_FORMAT = DateFormat.getTimeInstance(DateFormat.SHORT);
    
    private static final int ID_DATE_DIALOG = 0;
    private static final int ID_TIME_DIALOG = 1;
    
    private final DatePickerDialog.OnDateSetListener DATE_SET_LISTENER =
        new DatePickerDialog.OnDateSetListener() {
        
            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                    int dayOfMonth) {
                datetime.set(Calendar.YEAR, year);
                datetime.set(Calendar.MONTH, monthOfYear);
                datetime.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                textDate.setText(DATE_FORMAT.format(datetime.getTime()));
            }
    };
    
    private final TimePickerDialog.OnTimeSetListener TIME_SET_LISTENER =
        new TimePickerDialog.OnTimeSetListener() {
            
            @Override
            public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
                datetime.set(Calendar.HOUR_OF_DAY, hourOfDay);
                datetime.set(Calendar.MINUTE, minute);
                textTime.setText(TIME_FORMAT.format(datetime.getTime()));
            }
    };
    
    private DatePickerDialog datePickerDialog = null;
    private TimePickerDialog timePickerDialog = null;
    
    private TextView textDate = null;
    private TextView textTime = null;
    
    private Calendar datetime = Calendar.getInstance();
    
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.input);
        
        datePickerDialog = new DatePickerDialog(
                this, DATE_SET_LISTENER,
                datetime.get(Calendar.YEAR),
                datetime.get(Calendar.MONTH),
                datetime.get(Calendar.DAY_OF_MONTH));
        timePickerDialog = new TimePickerDialog(
                this, TIME_SET_LISTENER,
                datetime.get(Calendar.HOUR_OF_DAY),
                datetime.get(Calendar.MINUTE),
                true);
        
        textDate = (TextView) findViewById(R.id.text_date);
        textTime = (TextView) findViewById(R.id.text_time);
    }
    
    public void onClickButtonDate(View view) {
        showDialog(ID_DATE_DIALOG);
    }
    
    public void onClickButtonTime(View view) {
        showDialog(ID_TIME_DIALOG);
    }
    
    public void onClickButtonSave(View view) {
        // TODO Not yet implemented
        
        DistancePickerDialog distanceDialog = new DistancePickerDialog(this);
        distanceDialog.show();
    }
    
    public void onClickButtonClear(View view) {
        // TODO Not yet implemented
        Toast.makeText(this, "TODO! onClickButtonClear", Toast.LENGTH_LONG).show();
    }
    
    @Override
    protected Dialog onCreateDialog(int id) {
        switch (id) {
            case ID_DATE_DIALOG:
                return datePickerDialog;
            case ID_TIME_DIALOG:
                return timePickerDialog;
            default:
                throw new AssertionError("id = " + id);
        }
    }
    
    @Override
    protected void onPrepareDialog(int id, Dialog dialog) {
        switch (id) {
            case ID_DATE_DIALOG:
                datePickerDialog.updateDate(
                        datetime.get(Calendar.YEAR),
                        datetime.get(Calendar.MONTH),
                        datetime.get(Calendar.DAY_OF_MONTH));
                break;
            case ID_TIME_DIALOG:
                timePickerDialog.updateTime(
                        datetime.get(Calendar.HOUR_OF_DAY),
                        datetime.get(Calendar.MINUTE));
                break;
            default:
                throw new AssertionError("id = " + id);
        }
    }
}