package jp.ne.motoki.android.fuelchecker;

import android.content.Context;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

public abstract class ValueDisplayableDialogPreference<E extends ViewGroup>
        extends DialogPreference {
    
    private final E PICKER;

    private int originalLayoutId = View.NO_ID;
    private TextView inputValueTextView;

    public ValueDisplayableDialogPreference(
            Context context, AttributeSet attrs, E picker) {
        super(context, attrs);
        if (picker == null) {
            throw new NullPointerException("picker == null");
        }
        PICKER = picker;
    }

    public ValueDisplayableDialogPreference(Context context,
            AttributeSet attrs, int defStyle, E picker) {
        super(context, attrs, defStyle);
        if (picker == null) {
            throw new NullPointerException("picker == null");
        }
        PICKER = picker;
    }

    @Override
    protected View onCreateView(ViewGroup parent) {
        Context context = getContext();
        LinearLayout baseLayout = new LinearLayout(context);
        baseLayout.setOrientation(LinearLayout.HORIZONTAL);
        baseLayout.setGravity(Gravity.CENTER_VERTICAL);
        
        LayoutInflater layoutInflater = LayoutInflater.from(context);

        if (originalLayoutId == View.NO_ID) {
            originalLayoutId = getLayoutResource();
        }
        
        View orgLayout = layoutInflater.inflate(getOriginalLayoutId(), null);
        
        inputValueTextView = new TextView(context);
        inputValueTextView.setGravity(Gravity.CENTER_VERTICAL|Gravity.RIGHT);
        
        updateDisplay();
        
        baseLayout.addView(orgLayout, new LinearLayout.LayoutParams(
                ViewGroup.LayoutParams.WRAP_CONTENT,
                ViewGroup.LayoutParams.WRAP_CONTENT));
        baseLayout.addView(inputValueTextView, 
                new LinearLayout.LayoutParams(
                        ViewGroup.LayoutParams.FILL_PARENT,
                        ViewGroup.LayoutParams.WRAP_CONTENT));
        setLayoutResource(android.R.id.widget_frame);
        return baseLayout;
    }

    @Override
    protected View onCreateDialogView() {
        return PICKER;
    }

    @Override
    protected void onDialogClosed(boolean positiveResult) {
        super.onDialogClosed(positiveResult);
        
        if (positiveResult) {
            onDialogOk(PICKER);
            updateDisplay();
        }
        
        ViewGroup parent = (ViewGroup) PICKER.getParent();
        parent.removeView(PICKER);
    }
    
    protected abstract void onDialogOk(E picker);
    
    protected abstract String getDisplayText();

    protected int getOriginalLayoutId() {
        return originalLayoutId;
    }
    
    private void updateDisplay() {
        inputValueTextView.setText(getDisplayText());
    }
}
