package jp.ne.motoki.android.fuelchecker;

import java.util.Calendar;

import android.util.Log;

public class Utils {

    private static final String TAG = "FuelChecker";
    private static final boolean DEBUG = true;
    
    private Utils() {
        throw new AssertionError("Utils cannot instantiated");
    }
    
    public static void log_d(String message) {
        if (DEBUG) {
            Log.d(TAG, message);
        }
    }
    
    public static void log_w(String message) {
        if (DEBUG) {
            Log.w(TAG, message);
        }
    }
    
    public static float toDateRangeFloat(Calendar datetime) {
        long temp = datetime.getTimeInMillis() / (1000 * 60);
        return ((float) temp) / (60 * 24);
    }
    
    public static Calendar floorByMonth(Calendar calendar) {
        Calendar retVal = (Calendar) calendar.clone();
        retVal.set(Calendar.DAY_OF_MONTH, 1);
        retVal.set(Calendar.HOUR_OF_DAY, 0);
        retVal.set(Calendar.MINUTE, 0);
        retVal.set(Calendar.SECOND, 0);
        retVal.set(Calendar.MILLISECOND, 0);
        return retVal;
    }
    
    public static Calendar roundByMonth(Calendar calendar) {
        Calendar retVal = floorByMonth(calendar);
        retVal.add(Calendar.MONTH, 1);
        return retVal;
    }
    
    public static Calendar floorByDay(Calendar calendar) {
        Calendar retVal = (Calendar) calendar.clone();
        retVal.set(Calendar.HOUR_OF_DAY, 0);
        retVal.set(Calendar.MINUTE, 0);
        retVal.set(Calendar.SECOND, 0);
        retVal.set(Calendar.MILLISECOND, 0);
        return retVal;
    }
    
    public static Calendar roundByDay(Calendar calendar) {
        Calendar retVal = floorByDay(calendar);
        retVal.add(Calendar.DAY_OF_MONTH, 1);
        return retVal;
    }
    
    public static String toXLabel(Calendar calendar) {
        int dayOfMonth = calendar.get(Calendar.DAY_OF_MONTH);
        String retVal = String.format("%02d", dayOfMonth);
        if (dayOfMonth == 1) {
            int month = calendar.get(Calendar.MONTH);
            retVal = String.format("%02d/", month + 1) + retVal;
            if (month == Calendar.JANUARY) {
                int year = calendar.get(Calendar.YEAR);
                retVal = retVal.concat(String.format("/%02d", year % 2000));
            }
        }
        return retVal;
    }
}
