package jp.ne.motoki.android.fuelchecker;

import java.text.DateFormat;
import java.util.Calendar;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TimePicker;

public class TimePickerDialogPreference
        extends ValueDisplayableDialogPreference<TimePicker> {
    
    private static final DateFormat FORMATTER =
        DateFormat.getTimeInstance(DateFormat.SHORT);
    
    private final Calendar CALENDAR = Calendar.getInstance();
    
    private OnTimeChangedListener listener = null;

    public TimePickerDialogPreference(Context context, AttributeSet attrs) {
        super(context, attrs, createTimePicker(context));
    }

    public TimePickerDialogPreference(
            Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle, createTimePicker(context));
    }
    
    public void setOnTimeChangedListener(OnTimeChangedListener listener) {
        this.listener = listener;
    }
    
    public int[] getTime() {
        int[] result = new int[] {
                CALENDAR.get(Calendar.HOUR_OF_DAY),
                CALENDAR.get(Calendar.MINUTE)
        };
        return result;
    }

    @Override
    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
    }
    
    @Override
    protected String getDisplayText() {
        return FORMATTER.format(CALENDAR.getTime());
    }

    @Override
    protected void onDialogOk(TimePicker picker) {
        int hour = picker.getCurrentHour();
        int minute = picker.getCurrentMinute();
        
        CALENDAR.set(Calendar.HOUR_OF_DAY, hour);
        CALENDAR.set(Calendar.MINUTE, minute);
        
        if (listener != null) {
            listener.onTimeChanged(hour, minute);
        }
    }
    
    private static TimePicker createTimePicker(Context context) {
        TimePicker picker = new TimePicker(context);
        picker.setIs24HourView(false);
        return picker;
    }
    
    public static interface OnTimeChangedListener {
        void onTimeChanged(int hour, int minute);
    }
}
