package jp.ne.motoki.android.fuelchecker;

import static jp.ne.motoki.android.fuelchecker.Utils.log_d;
import static jp.ne.motoki.android.fuelchecker.Utils.log_w;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class FuelDbAdapter {

    private static final String DATABASE_NAME = "data";
    private static final int DATABASE_VERSION = 1;
    
    private static final String TABLE_NAME = "fuels";
    static final String KEY_DATETIME = "datetime";
    static final String KEY_QUANTITY = "quantity";
    static final String KEY_DISTANCE = "distance";
    
    private static final String SQL_CREATE_TABLE = String.format(
            "CREATE TABLE %s (%s INTEGER PRIMARY KEY, %s INTEGER NOT NULL, %s INTEGER NOT NULL);",
            TABLE_NAME, KEY_DATETIME, KEY_QUANTITY, KEY_DISTANCE);
    private static final String SQL_DROP_TABLE = String.format(
            "DROP TABLE IF EXISTS %s", TABLE_NAME);
    
    private final Context context;

    private DatabaseHelper dbHelper = null;
    private SQLiteDatabase database = null;
    
    public FuelDbAdapter(Context context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        this.context = context;
    }
    
    public void open() {
        dbHelper  = new DatabaseHelper(context);
        database  = dbHelper.getWritableDatabase();
    }
    
    public void close() {
        dbHelper.close();
    }
    
    public long insert(FuelData fuelData) {
        ContentValues values = fuelData.toContentValues();
        long rowId = database.insert(TABLE_NAME, null, values);
        log_d("rowId = " + rowId);
        return rowId;
    }
    
    public Cursor fetchAllData() {
        return database.query(TABLE_NAME, null, null, null, null, null, KEY_DATETIME);
    }
    
    private class DatabaseHelper extends SQLiteOpenHelper {
        private DatabaseHelper(Context context) {
            super(context, DATABASE_NAME, null, DATABASE_VERSION);
        }

        @Override
        public void onCreate(SQLiteDatabase db) {
            log_d("Create database");
            db.execSQL(SQL_CREATE_TABLE);
        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            log_w(String.format(
                    "Upgrade database : version %d to %d",
                    oldVersion, newVersion));
            db.execSQL(SQL_DROP_TABLE);
            db.execSQL(SQL_CREATE_TABLE);
        }
    }
}
