# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

import ConfigParser
from ftg.utils.common import CommonUtils


class BaseConfigParser():
    CONFIG_FILE_READ_SUCCESS = 0
    CONFIG_FILE_READ_FAILED = -1

    def __init__(self, util, config_file):
        self.util = util
        self.config_file = config_file

    def parse_config(self):
        self.config = ConfigParser.SafeConfigParser()
        self.config.optionxform = str
        success_files = self.config.read(self.config_file)
        if success_files == []:
            return self.CONFIG_FILE_READ_FAILED
        else:
            return self.CONFIG_FILE_READ_SUCCESS

    def get_config(self):
        return self.cofig

    def get_sections(self):
        return sorted(self.config.sections())

    def get_items(self, section):
        return self.config.items(section)

    def get_items_as_dict(self, section):
        item_dict = {}
        for key_value in self.config.items(section):
            (item_key, item_value) = key_value
            item_dict[item_key] = item_value
        return item_dict

    def get_item(self, section, item_name):
        return self.config.get(section, item_name)
