﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Audio;
using WindowsGame1;

namespace FrkEffectViewer.GameSystem
{
    class SoundManager
    {
        public float fVol;
        public const int SOUND_NUM = 32;
        public const int PLAY_NUM = 16;
        static private SoundManager pInstance;
        class SoundData
        {
            public SoundEffect se;
            public SoundEffectInstance[] si = new SoundEffectInstance[PLAY_NUM];
            public bool bPlay;
            public int[] nCnt = new int[PLAY_NUM];
            public bool[] bNextPlay = new bool[PLAY_NUM];
            public void SetSi()
            {
                for (int i = 0; i < PLAY_NUM; i++)
                {
                    si[i] = se.CreateInstance();
                    nCnt[i] = 0;
                    bNextPlay[i] = false;
                }
            }
        };
        //メンバ
        Dictionary<String, SoundData> SoundList;

        //実体の取得
        public static SoundManager getInstance()
        {
            if (pInstance == null)
                pInstance = new SoundManager();
            return pInstance;
        }
        //コンストラクタ
        private SoundManager()
        {
            fVol = 1.0f;
            SoundList = new Dictionary<String, SoundData>(SOUND_NUM);
        }
        //再生
        public SoundEffect PlaySound(String key)
        {
            SoundData p;
            if (key == null)
                return null;
            if (!SoundList.TryGetValue(key, out p))
            {
                SetSound(key);
            }
            //同一フレームに同じ音は鳴らさない
            SoundData data = SoundList[key];
            if (!data.bPlay)
            {
                int nOldIndex = 0;
                int w = 0;
                int i;
                for (i = 0; i < PLAY_NUM; i++)
                {
                    if (w > data.nCnt[i])
                    {
                        nOldIndex = i;
                        w = data.nCnt[i];
                    }
                    if (data.si[i].State == SoundState.Stopped)
                    {
                        data.si[i].Play();
                        data.nCnt[i] = 0;
                        break;
                    }
                }
                if (i == PLAY_NUM)
                {
                    //全部再生中の場合、一番古い奴を消して再生フラグを立てる
                    data.si[nOldIndex].Stop();
                    data.nCnt[nOldIndex] = 0;
                    data.bNextPlay[nOldIndex] = true;
                }
                SoundList[key].bPlay = true;
                //SoundList[key].si.Play();
            }
            return SoundList[key].se;
        }
        //テクスチャの登録
        public bool SetSound(String name)
        {
            SoundData p;
            //もし登録済みなら失敗を返す
            if (SoundList.TryGetValue(name, out p))
            {
                //登録済みなのでreturn
                return false;
            }
            if (p == null)
            {
                p = new SoundData();
            }
            //連装配列にセット
            p.se = GameMain.game.Content.Load<SoundEffect>(name);
            p.SetSi();
            p.bPlay = false;

            SoundList.Add(name, p);
            return true;
        }
        public void UpDate()
        {
            foreach (KeyValuePair<String,SoundData> data in SoundList)
            {
                data.Value.bPlay = false;
                for (int i = 0; i < PLAY_NUM; i++)
                {
                    data.Value.nCnt[i]++;
                    if (data.Value.bNextPlay[i])
                    {
                        data.Value.bNextPlay[i] = false;
                        data.Value.si[i].Play();
                    }
                }
            }
        }
    }
}
