using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using FrkEffectViewer.GameSystem;
using FrkEffectViewer;
using System.IO;
using System.Reflection;
using FrkEffectLib;
namespace WindowsGame1
{
    public class GameMain : Microsoft.Xna.Framework.Game
    {
        private static SpriteBatch spriteBatch;//XvCgob`
        private static SpriteFont font;       //tHg
        public static ContentManager ContentMng;
        public static Graphics Grf;
        public static Game game;
        private GameManager GameMng;
        
        //RXgN^
        public GameMain()
        {
            Grf = new Graphics(this);
            ContentMng = Content;
            ContentMng.RootDirectory = "Content";
            Grf.GetGraphicsDeviceManager().MinimumPixelShaderProfile = ShaderProfile.PS_2_0;
        }

        //
        protected override void Initialize()
        {
            base.Initialize();
            GameMng = GameManager.GetGameManager();
            game = this;
            GameMng.Init();
            game.IsFixedTimeStep = false;

        }

        //OtBNXReg̓ǂݍ
        protected override void LoadContent()
        {
            Grf.LoadContent();
            spriteBatch = new SpriteBatch(GraphicsDevice);
            font = ContentMng.Load<SpriteFont>("DefaultFont");

        }

        //OtBNXReg̉
        protected override void UnloadContent()
        {
        }
        //XV
        protected override void Update(GameTime gameTime)
        {   
            //IuWFNgx[X̎ԂXV
            ObjectBase.GameTime = gameTime;
            
            //x[X̍XV
            //base.Update(gameTime);

            //AvI{CQ[
            if (GameMng.MainProc(gameTime))
            {
                Exit();
            }
        }


        //`
        protected override void Draw(GameTime gameTime)
        {
            //wi̕`
            //Grf.GetGraphicsDeviceManager().GraphicsDevice.Clear(Color.CornflowerBlue);
            Grf.GetGraphicsDeviceManager().GraphicsDevice.Clear(Color.Black);
            //x[X̕`
            GameMng.DrawBegin();
            //base.Draw(gameTime);
            GameMng.DrawEnd();
            //̕`
            spriteBatch.Begin();

            GameMain.DrawString("FPS: " + GameMng.fps.ToString("0.000") + " EffectObjNum:" + FrkEffectLib.FrkLibEffectManager.GetInstance().GetEffectNum(), 0, 0);
            GameMain.DrawString("Scale:" + GameMng.CreateScale.ToString("0.0") + " MoveType:" + GameMng.szCreatePointMoveType[GameMng.CreatePointMoveType] + " MoveSpd:" + GameMng.CreatePointMoveSpd.ToString("0.0"), 0, 26);
            GameMain.DrawString("F1:Load\n1:Create(NoAccess)\n2:Create(Access)\n0:Delete\nW:ScaleUp\nQ:ScaleDown\nX:SpdUp\nZ:SpdDown\nAS:Change_MoveCreatePoint", 0, 50);        
            spriteBatch.End();

        }

        //̕`
        public static void DrawString(String str, int x, int y)
        {
            spriteBatch.DrawString(font, str, new Vector2(x, y), Color.White);
        }
    }
}
