﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using FrkEffectViewer.GameSystem;

namespace WindowsGame1
{
    class GameObject3D : ObjectBase
    {
        public Model pModel;
        public Quaternion Qua;
        public Vector3 Scale;
        protected BasicEffect basicEffect;
        protected GraphicsDevice GrfDevice;

        public int nTime;

        //メンバ
        public Vector3 Pos;

        public GameObject3D()
        {
            nTime = 0;
            Qua = new Quaternion(0, 0, 0, 1);
            pModel = null;
            Scale = new Vector3(1, 1, 1);
            GrfDevice = GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice;
            basicEffect = new BasicEffect(GrfDevice, null);
            basicEffect.VertexColorEnabled = true;
        }
        public virtual bool UniqueMain()
        {
            return false;
        }
        public override bool Main()
        {
            nTime++;
            return UniqueMain();
        }
        public override void Draw()
        {
            Matrix CamMat = CamManager.GetCamManager().GetNowCamera().GetMatrix();
            Matrix CamProj = CamManager.GetCamManager().GetNowCamera().GetProj();


            // ワールド座標変換行列
            Matrix world = Matrix.CreateScale(Scale) * Matrix.CreateFromQuaternion(Qua)
                                        * Matrix.CreateTranslation(Pos);               // 移動

            // ビュー座標変換行列
            Matrix view = CamMat;

            // 射影変換行列
            Matrix projection = CamProj;

            if (pModel != null)
            {
                //モデルがあった場合


                GrfDevice.RenderState.DepthBufferEnable = true;
                GrfDevice.RenderState.DepthBufferWriteEnable = true;
                //モデルの設定
                foreach (ModelMesh mesh in pModel.Meshes)
                {
                    foreach (BasicEffect effect in mesh.Effects)
                    {
                        //ライト
                        effect.EnableDefaultLighting();
                        effect.View = view;
                        effect.World = world;
                        effect.Projection = projection;

                        effect.FogColor = new Vector3(0, 0, 0);
                        effect.FogEnabled = true;
                        effect.FogStart = 0;
                        effect.FogEnd = 1024;
                    }
                    mesh.Draw();
                }
            }

        }

        public override void End()
        {
            //何もしない
        }


    }
}
