using System;

namespace freetrain.world.soccerstadium
{
	/// <summary>
	/// Opponent team.
	/// </summary>
	[Serializable]
	public class OpponentTeam
	{
		/// <summary> Name of the team. </summary>
		public readonly string name;
		/// <summary> Strength of the team. </summary>
		public readonly int strength;

		private OpponentTeam( string _name, int _strength ) {
			this.name = _name;
			this.strength = _strength;
		}

		public static readonly OpponentTeam[] OPPONENTS = new OpponentTeam[]{
			new OpponentTeam("TK|",0),
			new OpponentTeam("z[[zbNO",10),
			new OpponentTeam("Ökx}[",20),
			new OpponentTeam("RTh[y",30),
			new OpponentTeam("BbZ",40),
			new OpponentTeam("Ws֌",50),
			new OpponentTeam("Ag[Y",60),
			new OpponentTeam("xfB",70),
			new OpponentTeam("ؔC\",80),
			new OpponentTeam("Yau[X",90),
			new OpponentTeam("GXvY",100)
		};


		/// <summary>
		/// Select one team randomly.
		/// </summary>
		public static OpponentTeam drawRandom() {
			return OPPONENTS[Const.rnd.Next(OPPONENTS.Length)];
		}
	}
}
