package jp.sourceforge.freegantt.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;

import jp.sourceforge.freegantt.locale.Resource;
import jp.sourceforge.freegantt.print.PreviewDialog;

public class ApplicationItemMenu extends JPanel {
	private static final long serialVersionUID = -4041049775879993378L;
	
	Application app;

	public ApplicationItemMenu(final Application app) {
		this.app = app;
		
		FlowLayout layout = new FlowLayout(FlowLayout.LEFT);
		layout.setVgap(2);
		layout.setHgap(2);
		
		setLayout(layout);
		setPreferredSize(new Dimension(Integer.MAX_VALUE, 28));
		

		add(createButton(
				Resource.get("menuFileNew"),
				"menuFileNew.png",
				new ActionListener(){
					@Override
					public void actionPerformed(ActionEvent e) {
						app.newFile();
					}
				}
				));
		add(createButton(
				Resource.get("menuFileOpen"),
				"menuFileOpen.png",
				new ActionListener(){
					@Override
					public void actionPerformed(ActionEvent e) {
						app.loadData();
					}
				}
				));
		add(createButton(
				Resource.get("menuFileSave"),
				"menuFileSave.png",
				new ActionListener(){
					@Override
					public void actionPerformed(ActionEvent e) {
						app.saveData();
					}
				}
				));
		add(createButton(
				Resource.get("menuFileSaveAs"),
				"menuFileSaveAs.png",
				new ActionListener(){
					@Override
					public void actionPerformed(ActionEvent e) {
						app.saveAsData();
					}
				}
				));
		add(new Sepalator());
		add(createButton(
				Resource.get("menuFilePreview"),
				"menuFilePreview.png",
				new ActionListener(){
					@Override
					public void actionPerformed(ActionEvent e) {
						PreviewDialog dialog = new PreviewDialog(app);
						dialog.setVisible(true);
					}
				}
				));
		add(createButton(
				Resource.get("menuFilePage"),
				"menuFilePage.png",
				new ActionListener(){
					@Override
					public void actionPerformed(ActionEvent e) {
						app.configurePage();
					}
				}
				));
		add(createButton(
				Resource.get("menuFilePrint"),
				"menuFilePrint.png",
				new ActionListener(){
					@Override
					public void actionPerformed(ActionEvent e) {
						app.print();
					}
				}
				));
		add(new Sepalator());
		add(createButton(
				Resource.get("menuViewCalendarMode"),
				"menuViewCalendarMode.png",
				new ActionListener(){
					@Override
					public void actionPerformed(ActionEvent e) {
						app.changeCalendarMode();
					}
				}
				));
		add(createButton(
				Resource.get("menuViewProgress"),
				"menuViewProgress.png",
				new ActionListener(){
					@Override
					public void actionPerformed(ActionEvent e) {
						app.getTaskLineDataPane().setProgressLineMode(!app.getTaskLineDataPane().isProgressLineMode());
						app.getTaskLineDataPane().repaint();
					}
				}
				));
			add(createButton(
				Resource.get("menuViewPage"),
				"menuViewPage.png",
				new ActionListener(){
					@Override
					public void actionPerformed(ActionEvent e) {
						app.getTaskLineDataPane().setPrintRangeMode(!app.getTaskLineDataPane().isPrintRangeMode());
						app.getTaskLineDataPane().repaint();
					}
				}
				));
	add(new Sepalator());
		add(createButton(
				Resource.get("menuWindowInfo"),
				"menuWindowInfo.png",
				new ActionListener(){
					@Override
					public void actionPerformed(ActionEvent e) {
						app.openConfig(Application.CONFIG_PROJECT);
					}
				}
				));
		add(createButton(
				Resource.get("menuWindowResource"),
				"menuWindowResource.png",
				new ActionListener(){
					@Override
					public void actionPerformed(ActionEvent e) {
						app.openConfig(Application.CONFIG_MEMBER);
					}
				}
				));
		add(createButton(
				Resource.get("menuWindowHoliday"),
				"menuWindowHoliday.png",
				new ActionListener(){
					@Override
					public void actionPerformed(ActionEvent e) {
						app.openConfig(Application.CONFIG_HOLIDAY);
					}
				}
				));
	}
	
	public JButton createButton(String tooltip, String filename, ActionListener listener) {
		JButton button = new JButton();
		button.setUI(new BasicButtonUI());
		button.setBorder(new MenuItemBorder());
		button.setIcon(new ImageIcon(getClass().getResource(filename)));
		button.addActionListener(listener);
		button.setPreferredSize(new Dimension(24, 24));
		button.setToolTipText(tooltip);
		return button;
	}
	
	class Sepalator extends JPanel {
		private static final long serialVersionUID = 5819409774260437397L;

		public Sepalator() {
			setPreferredSize(new Dimension(9, 24));
			setBorder(BorderFactory.createEmptyBorder());
		}

		@Override
		public void paint(Graphics g) {
			g.setColor(Color.gray);
			g.drawLine(4, 1, 4, getHeight() - 2);
		}
	}
}
