package jp.sourceforge.freegantt.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;

import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.util.GraphicsUtil;

public class GanttChartPrintable implements Printable, Pageable {
	
	Application app;
	
	Color borderColor = new Color(0x30, 0x30, 0x30);
	
	public static PageFormat getDefaultPageFormat() {
		PrinterJob job = PrinterJob.getPrinterJob();
		PageFormat pageFormat = job.defaultPage();
		pageFormat.setOrientation(PageFormat.LANDSCAPE);
		return pageFormat;
	}
	
	public GanttChartPrintable(Application app) {
		this.app = app;
	}

	@Override
	public int getNumberOfPages() {
		return app.getTaskLineDataPane().getPrintRange().getPrintRanges().size();
	}

	@Override
	public PageFormat getPageFormat(int pageIndex)
			throws IndexOutOfBoundsException {
		return app.getProject().getPrint().getPageFormat();
	}


	@Override
	public Printable getPrintable(int pageIndex)
			throws IndexOutOfBoundsException {
		return this;
	}

	@Override
	public int print(Graphics g, PageFormat pageFormat, int pageIndex)
			throws PrinterException {
		List<Rectangle> ranges = app.getTaskLineDataPane().getPrintRange().getPrintRanges();
		
		Graphics2D g2d = (Graphics2D)g;
		g2d.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
		
		
		if (pageIndex < ranges.size()) {
			Rectangle range = ranges.get(pageIndex);

			int titleHeight = app.getTaskLineDataPane().getCellHeight();
			int headerHeight = app.getTaskListTable().getTableHeader().getHeight();
			int taskListWidth = app.getTaskListTable().getWidth();
			int taskListHeight = app.getTaskListTable().getHeight();
			
			int imageWidth = taskListWidth + range.width;
			int imageHeight = titleHeight + headerHeight + range.height;
			double scaleX = pageFormat.getImageableWidth() / imageWidth;
			double scaleY = pageFormat.getImageableHeight() / imageHeight;
			double scale = Math.min(scaleX, scaleY);
			
			AffineTransform transform = g2d.getTransform();
			transform.scale(scale, scale);
			g2d.setTransform(transform);

			// TODO 中央寄せする場合はここに記述
			
			// プロジェクト名の描画
			StringBuilder title = new StringBuilder();
			title.append( app.getProject().getName() );
			if (ranges.size() > 1) {
				title.append(" (" + (pageIndex + 1) + "/" + ranges.size() + ")");
			}
			GraphicsUtil.drawStringLeft(g2d, title.toString(), 0, 0, 1, titleHeight);
			g2d.translate(1, titleHeight);
			
			// タスクテーブルヘッダの描画
			Shape oldClip = g2d.getClip();
			g2d.setClip(new Rectangle(0, 0, taskListWidth, taskListHeight));
			app.getTaskListTable().getTableHeader().print(g2d);
			g2d.setClip(oldClip);
			
			// タスクテーブルの描画
			g2d.translate(0, headerHeight);
			g2d.translate(0, - range.y);
			oldClip = g2d.getClip();
			g2d.setClip(new Rectangle(0, range.y, taskListWidth, range.height));
			app.getTaskListTable().print(g2d);
			g2d.setClip(oldClip);
			g2d.translate(0, range.y);
			g2d.translate(0, - headerHeight);
			
			// チャートヘッダの描画
			g2d.translate(taskListWidth, 0);
			g2d.translate(- range.x, 0);
			oldClip = g2d.getClip();
			g2d.setClip(new Rectangle(range.x, 0, range.width, headerHeight));
			app.getTaskLineHeaderPane().paint(g2d);
			g2d.setClip(oldClip);
			g2d.translate(range.x, 0);
			g2d.translate(- taskListWidth, 0);
			
			// チャートの描画
			g2d.translate(taskListWidth, headerHeight);
			boolean oldPrintRangeMode = app.getTaskLineDataPane().isPrintRangeMode();
			app.getTaskLineDataPane().setPrintRangeMode(false);
			g2d.translate(- range.x, - range.y);
			oldClip = g2d.getClip();
			g2d.setClip(new Rectangle(range.x, range.y, range.width, range.height));
			app.getTaskLineDataPane().paint(g2d);
			g2d.setClip(oldClip);
			g2d.translate(range.x, range.y);
			app.getTaskLineDataPane().setPrintRangeMode(oldPrintRangeMode);
			g2d.translate(- taskListWidth, - headerHeight);
			
			// 外枠の描画
			oldClip = g2d.getClip();
			g2d.setClip(0, 0, taskListWidth + range.width, headerHeight + range.height);
			GraphicsUtil.drawRect(g2d, 0, 0, taskListWidth + range.width - 1, headerHeight + range.height - 1);
			g2d.setClip(oldClip);
			
			return Printable.PAGE_EXISTS;
		} else {
			return Printable.NO_SUCH_PAGE;
		}
	}


}
