package jp.sourceforge.freegantt.data.undo;

import java.util.Calendar;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;

public class CreateAdditionalHolidayEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = -4667694082936530048L;

	Project project;
	Calendar newCalendar;
	int index;
	
	public CreateAdditionalHolidayEdit(Project project, Calendar calendar, int index) {
		this.project = project;
		this.newCalendar = (Calendar)calendar.clone();
		this.index = index;
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().removeAdditionalHoliday(index);
	}

	@Override
	public void redo() throws CannotRedoException {
		System.out.println("Redo " + getClass().toString());
		super.redo();
		project.getController().addAdditionalHoliday(newCalendar, index);
	}

	@Override
	public void die() {
		super.die();
		project = null;
		newCalendar = null;
	}
}
