package jp.sourceforge.freegantt.swing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;

import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.TableColumn;

public class GanttChartSplitPane extends JSplitPane {
	private static final long serialVersionUID = -8567327389185691533L;

	Application app;
	Integer maximumDividerLocation;
	int openedDividerLocation = 0;
	int columnStickWidth = 8;

	public GanttChartSplitPane(Application app, int newOrientation) {
		super(newOrientation);
		this.app = app;
		GanttChartSplitPaneUI ui = new GanttChartSplitPaneUI();
		setUI(ui);
		ui.getDivider().addMouseListener(new DividerMouseListener());
		addPropertyChangeListener(new DividerLocationChangeListener());
	}

	@Override
	public void setDividerLocation(int location) {
		super.setDividerLocation(location);
		app.getProject().getView().setTaskTableWidth(location);

		if (location > 10) {
			openedDividerLocation = location;
		}
	}

	public void setMaximumDividerLocation(int location) {
		maximumDividerLocation = location;
	}

	@Override
	public int getMaximumDividerLocation() {
		if (maximumDividerLocation != null)
			return maximumDividerLocation;
		return super.getMaximumDividerLocation();
	}

	class GanttChartSplitPaneUI extends BasicSplitPaneUI {
		public BasicSplitPaneDivider getDivider() {
			return divider;
		}
	}

	class DividerMouseListener implements MouseListener {
		@Override
		public void mouseClicked(MouseEvent e) {
			if (e.getClickCount() == 2) {
				setDividerLocation(getDividerLocation() < 10 ? openedDividerLocation
						: 0);
			}
		}

		@Override
		public void mousePressed(MouseEvent e) {
		}

		@Override
		public void mouseReleased(MouseEvent e) {
		}

		@Override
		public void mouseEntered(MouseEvent e) {
		}

		@Override
		public void mouseExited(MouseEvent e) {
		}
	}

	class DividerLocationChangeListener implements PropertyChangeListener {
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
			if (evt.getPropertyName().equals(
					JSplitPane.DIVIDER_LOCATION_PROPERTY)) {
				if (maximumDividerLocation != null
						&& (Integer) evt.getNewValue() > maximumDividerLocation) {
					setDividerLocation(maximumDividerLocation);
					return;
				}
				
				JTable table = app.getTaskListPane();
				if (table == null) return;
				List<TableColumn> columns = Collections.list(table.getColumnModel().getColumns());
				int width = 1;
				JScrollBar bar =  app.getTaskListRootPane().getVerticalScrollBar();
				width += bar.getWidth();
				for (TableColumn column: columns) {
					width += column.getWidth();
					if ((Integer) evt.getNewValue() >= width - columnStickWidth && 
							(Integer) evt.getNewValue() <= width + columnStickWidth) {
						setDividerLocation(width);
					}
				}
			}
		}
	}
}
