package jp.sourceforge.freegantt.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CalendarUtil {
	
	private static Pattern DATE_PATTERN = Pattern.compile("([1-2][0-9]{3})/([0-9]{1,2})/([0-9]{1,2})");
	private static Pattern DATE_PATTERN_NUMERIC = Pattern.compile("([1-2][0-9]{3})([0-9]{2})([0-9]{2})");

	public static Calendar toDateCalendar(long millis) {
		Calendar cal = Calendar.getInstance();
		cal.setTimeInMillis(millis);
		return toDateCalendar(cal);
	}
	
	public static Calendar toDateCalendar(Calendar cal) {
		cal.set(Calendar.HOUR, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal;
	}
	
	public static Calendar get(int year, int month, int day) {
		Calendar cal = Calendar.getInstance();
		cal.set(year, month, day);
		return toDateCalendar(cal);
	}
	
	public static Calendar parseDate(String str, Locale locale) {
		if (locale.getLanguage().equals(Locale.JAPANESE.getLanguage())) {
			try {
				SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd", locale);
				Date date = format.parse(str);
				return toDateCalendar(date.getTime());
			} catch (ParseException e) {
			}
			try {
				SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd", locale);
				Date date = format.parse(str);
				return toDateCalendar(date.getTime());
			} catch (ParseException e) {
			}
		} else {
			try {
				SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy", locale);
				Date date = format.parse(str);
				return toDateCalendar(date.getTime());
			} catch (ParseException e) {
			}
			try {
				SimpleDateFormat format = new SimpleDateFormat("ddMMyyyy", locale);
				Date date = format.parse(str);
				return toDateCalendar(date.getTime());
			} catch (ParseException e) {
			}
		}
		
//		Matcher matcher = DATE_PATTERN.matcher(str);
//		if (matcher.find()) {
//			int year = Integer.parseInt(matcher.group(1));
//			int month = Integer.parseInt(matcher.group(2).replaceFirst("^0", "")) - 1;
//			int day = Integer.parseInt(matcher.group(3).replaceFirst("^0", ""));
//			
//			return get(year, month, day);
//		}
//		
//		matcher = DATE_PATTERN_NUMERIC.matcher(str);
//		if (matcher.find()) {
//			int year = Integer.parseInt(matcher.group(1));
//			int month = Integer.parseInt(matcher.group(2).replaceFirst("^0", "")) - 1;
//			int day = Integer.parseInt(matcher.group(3).replaceFirst("^0", ""));
//			
//			return get(year, month, day);
//		}
		
		return null;
	}
	
	public static int subDate(Calendar lhs, Calendar rhs) {
		if (lhs == null || rhs == null) return 0;
		return (int)((lhs.getTimeInMillis() - rhs.getTimeInMillis()) / 86400000);
	}
}
