﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices.WindowsRuntime;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using Windows.System;

// 空白ページのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234238 を参照してください

namespace FooEditor
{
    /// <summary>
    /// それ自体で使用できる空白ページまたはフレーム内に移動できる空白ページ。
    /// </summary>
    public sealed partial class AboutFlyout : SettingsFlyout
    {
        public AboutFlyout()
        {
            this.InitializeComponent();
            this.DataContext = new AboutFlyoutViewModel();
        }
    }

    class AboutFlyoutViewModel
    {
        const string privacyUrl = "http://fooeditor.sourceforge.jp/privacy.html";
        const string supportUrl = "http://fooeditor.sourceforge.jp/howto_metro.html";

        public DelegateCommand<object> PrivacyCommand
        {
            get
            {
                return new DelegateCommand<object>(async (param) =>
                {
                    await Launcher.LaunchUriAsync(new Uri(privacyUrl));
                });
            }
        }

        public DelegateCommand<object> SupportCommand
        {
            get
            {
                return new DelegateCommand<object>(async (param) =>
                {
                    await Launcher.LaunchUriAsync(new Uri(supportUrl));
                });
            }
        }

        public string AppTitle
        {
            get
            {
                return Windows.ApplicationModel.Package.Current.DisplayName;
            }
        }
        
        public string VersionText
        {
            get
            {
                var loader = new Windows.ApplicationModel.Resources.ResourceLoader();
                return string.Format(loader.GetString("VersionText"), GetApplicationVersion());
            }
        }

        string GetApplicationVersion()
        {
            var ver = Windows.ApplicationModel.Package.Current.Id.Version;
            return ver.Major.ToString() + "." + ver.Minor.ToString() + "." + ver.Build.ToString() + "." + ver.Revision.ToString();
        }
    }
}
