﻿using System;
using System.Collections.Generic;
using Windows.Foundation;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.ViewManagement;
using Windows.UI.Core;
using Windows.System;
using FooEditEngine;

static class LineBreakMethodEnumCollection
{
    public static List<LineBreakMethod> Get()
    {
        List<LineBreakMethod> methodList = new List<LineBreakMethod>();
        methodList.Add(LineBreakMethod.None);
        methodList.Add(LineBreakMethod.CharUnit);
        methodList.Add(LineBreakMethod.PageBound);
        return methodList;
    }
}

static class FlyoutUtils
{
    // フライアウトを表示する際の左右の画面マージン
    private static readonly int RightAndLeftMargin = 20;
    // フライアウトを表示する際の下の画面マージン
    private static readonly int BottomMargin = 20;

    public static Popup CreateFlyoutUnderTopAppBar<TFlyoutContent>(TFlyoutContent content)
        where TFlyoutContent : FrameworkElement
    {
        // 余白を考慮した画面幅
        content.Width = Math.Min(Window.Current.Bounds.Width - RightAndLeftMargin * 2, content.Width);

        var popup = new Popup
        {
            // コンテンツを子としてもつPopup
            Child = content,
            // Popup外を操作された場合に自動で閉じるようにする
            IsLightDismissEnabled = true
        };

        Point pt = new Point(Window.Current.Bounds.Right - content.Width,Window.Current.Bounds.Top);

        Canvas.SetTop(popup, pt.Y);
        Canvas.SetLeft(popup, pt.X);

        return popup;
    }
}

static class WindowUtils
{
    public static bool IsModiferKeyPressed(VirtualKey key)
    {
        CoreVirtualKeyStates state = Window.Current.CoreWindow.GetKeyState(key);
        return (state & CoreVirtualKeyStates.Down) == CoreVirtualKeyStates.Down;
    }
}