﻿using System;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;

namespace FooEditor
{
    class DocumentCollectionEventArgs
    {
        public int ActiveIndex;
        public DocumentCollectionEventArgs(int index)
        {
            this.ActiveIndex = index;
        }
    }

    [CollectionDataContract]
    class DocumentCollection : ObservableCollection<DocumentPageInfo>
    {
        public static DocumentPageInfo Empty = new DocumentPageInfo();

        [DataMember]
        int _CurrentDocumentIndex;

        public DocumentCollection()
        {
            this.Initialize();
        }

        private void Initialize()
        {
            this.ActiveDocumentChanged += (s, e) => { };
            this.CollectionChanged += (s, e) => { };
            this.PropertyChanged += (s, e) => { };
        }

        public DocumentPageInfo Current
        {
            get
            {
                if (this.Count == 0)
                    return DocumentCollection.Empty;
                else
                    return this[_CurrentDocumentIndex];
            }
        }

        public event EventHandler<DocumentCollectionEventArgs> ActiveDocumentChanged;

        public void RemoveDocument(DocumentPageInfo param)
        {
            int index = this.IndexOf(param);
            if (index != -1)
            {
                this.RemoveAt(index);
                if(this.Count > 0)
                    this.ActiveDocument(index == 0 ? 0 : index - 1);
            }
        }

        public void AddDocument(DocumentPageInfo info)
        {
            this.Add(info);
            this.ActiveDocument(info);
        }

        public void Next()
        {
            int selIndex = this._CurrentDocumentIndex + 1;
            if (selIndex > this.Count - 1)
                selIndex = 0;
            this.ActiveDocument(selIndex);
        }

        public void Prev()
        {
            int selIndex = this._CurrentDocumentIndex - 1;
            if (selIndex < 0)
                selIndex = this.Count - 1;
            this.ActiveDocument(selIndex);
        }

        public void ActiveDocument(int index)
        {
            DocumentPageInfo info = this[index];
            _CurrentDocumentIndex = index;
            this.ActiveDocumentChanged(this, new DocumentCollectionEventArgs(index));
        }

        public void ActiveDocument(DocumentPageInfo info)
        {
            this.ActiveDocument(this.IndexOf(info));
        }

        public bool ActiveDocument(string file_name)
        {
            foreach (DocumentPageInfo doc_info in this)
            {
                if (doc_info.Title == file_name)
                {
                    this.ActiveDocument(doc_info);
                    return true;
                }
            }
            return false;
        }

        [OnDeserializing]
        private void SetValuesOnDeserializing(StreamingContext context)
        {
            Initialize();
        }
    }
}
