﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Windows.Foundation;
using Windows.Storage;
using Windows.Storage.Pickers;
using Windows.Storage.AccessCache;
using Windows.UI.Notifications;
using Windows.UI.Popups;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Navigation;
using Windows.Graphics.Printing;
using Windows.System.Threading;
using Windows​.Data​.Xml​.Dom;
using Microsoft.Toolkit.Uwp.Notifications;
using FooEditor.UWP.Models;
using FooEditor.UWP.Views;

namespace FooEditor.UWP.Services
{
    public interface IMainViewService
    {
        MainPage MainPage
        {
            get;
            set;
        }
        Task<bool> ConfirmRestoreUserState();
        Task MakeMessageBox(string s);
        void MakeNotifaction(string text);
    }

    public class MainViewService : IMainViewService
    {
        public MainPage MainPage
        {
            get;
            set;
        }

        public async Task<bool> ConfirmRestoreUserState()
        {
            if (!AppSettings.Current.EnableAutoSave)
                return false;
            var loader = new Windows.ApplicationModel.Resources.ResourceLoader();
            var msg = new MessageDialog(loader.GetString("RestoreUsareStateMessage"), "");
            msg.Commands.Add(new UICommand(loader.GetString("YesButton")));
            msg.Commands.Add(new UICommand(loader.GetString("NoButton")));
            var res = await msg.ShowAsync();
            return res.Label == loader.GetString("YesButton");
        }

        public async Task MakeMessageBox(string s)
        {
            var msg = new MessageDialog(s);
            await msg.ShowAsync();
        }

        public void MakeNotifaction(string text)
        {
            ToastContent toastContent = new ToastContent()
            {
                Scenario = ToastScenario.Default,
                Visual = new ToastVisual()
                {
                    BindingGeneric = new ToastBindingGeneric()
                    {
                        Children =
                        {
                            new AdaptiveText()
                            {
                                Text = text
                            },
                        },
                        AppLogoOverride = new ToastGenericAppLogo()
                        {
                            Source = "ms-appx:///Assets/StoreLogo.png"
                        }
                    }
                }
            };


            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.LoadXml(toastContent.GetContent());

            var toast = new ToastNotification(xmlDoc);
            ToastNotificationManager.CreateToastNotifier().Show(toast); // Display toast

        }
    }
}
