﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using SharpDX.DirectWrite;
namespace FooEditor
{
    static class FontFamillyCollection
    {
        public static List<string> GetFonts()
        {
            var fontList = new List<string>();

            var factory = new Factory();
            var fontCollection = factory.GetSystemFontCollection(new SharpDX.Bool(false));
            var familyCount = fontCollection.FontFamilyCount;

            for (int i = 0; i < familyCount; i++)
            {
                var fontFamily = fontCollection.GetFontFamily(i);
                var familyNames = fontFamily.FamilyNames;
                int index;

                if (!familyNames.FindLocaleName(CultureInfo.CurrentCulture.Name, out index))
                    familyNames.FindLocaleName("en-us", out index);

                string name = familyNames.GetString(index);
                fontList.Add(name);
            }

            fontList.Sort();

            return fontList;
        }
    }
}
