﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Drawing;
using FooEditor;
using FooEditor.Plugin;
using System.Windows.Forms;
using Outline.Properties;
using Microsoft.Win32;

namespace Outline
{
    struct OutlineInfo
    {
        public int StartRow;
        public int Count;
        public OutlineInfo(int startRow, int count)
        {
            this.StartRow = startRow;
            this.Count = count;
        }
    }
    [Export(typeof(IPlugin))]
    public class Outlline : IPlugin
    {
        Editor editor;
        OutlineForm OutlineForm;
        Dictionary<string, string[]> OutlineAnalyzePattern = new Dictionary<string, string[]>();
        const string OutlineAnalyzePatternPath = Config.RegAppPath + "\\OutlineAnalyzePattern";

        public void Initalize(Editor e)
        {
            this.editor = e;

            this.editor.ActiveContentChanged += new EventHandler(editor_ActiveContentChanged);

            RegistryKey regkey = Registry.CurrentUser.OpenSubKey(OutlineAnalyzePatternPath);
            if (regkey == null)
                regkey = SetDefalutAnalyzePattern();
            string[] names = regkey.GetValueNames();
            this.OutlineAnalyzePattern.Clear();
            foreach (string name in names)
                if (name != "")
                    this.OutlineAnalyzePattern.Add(name, (string[])regkey.GetValue(name));
            regkey.Close();
            regkey.Close();

            ToolStripMenuItem item = (ToolStripMenuItem)e.RootMenuStrip.Items[2];
            item.DropDownItems.Add(new ToolStripMenuItem(Resources.MenuName,null,outlineToolStripMenuItem_Click));
        }

        public void ClosedApp()
        {
            RegistryKey regkey = Registry.CurrentUser.CreateSubKey(OutlineAnalyzePatternPath);
            foreach (KeyValuePair<string, string[]> kv in OutlineAnalyzePattern)
                regkey.SetValue(kv.Key, kv.Value);
            regkey.Close();
        }

        public void ShowConfigForm()
        {
            ConfigForm form = new ConfigForm(this.OutlineAnalyzePattern);
            form.ShowDialog();
        }

        private RegistryKey SetDefalutAnalyzePattern()
        {
            RegistryKey regkey = Registry.CurrentUser.CreateSubKey(OutlineAnalyzePatternPath);
            regkey.SetValue("C/C++/C#/PHP/Java", new string[] { "(class|struct|interface|enum)\\s[a-z_]+", "^\\s*[a-z]*\\s*[a-z]+\\s[a-z_]+(\\().*(\\))" });
            regkey.SetValue("VisualBasic.NET", new string[] { "(class|module|structure|interface)\\s[a-z_]+", "(funtion|sub)\\s[a-z_]+(\\().*(\\))" });
            regkey.SetValue("JavaScript", new string[] { "(function)\\s[a-z_]+(\\().*(\\))" });
            regkey.SetValue("Ruby/Python", new string[] { "(class)\\s[a-z_]+", "(def)\\s[a-z_]+(\\().*(\\))" });
            regkey.SetValue("Perl", new string[] { "package\\s[a-z_]+", "(sub)\\s[a-z_]+(\\().*(\\))" });
            regkey.SetValue("WZ Text", new string[] { ".", ".." });
            return regkey;
        }

        void editor_ActiveContentChanged(object sender, EventArgs e)
        {
            EditForm active = this.editor.EditForm;
            if (active == null)
                return;
            if (OutlineForm != null && OutlineForm.IsDisposed == false)
                OutlineForm.currentForm= active;
        }

        private void outlineToolStripMenuItem_Click(object sender, EventArgs e)
        {
            EditForm active = this.editor.EditForm;
            if (this.OutlineForm == null || this.OutlineForm.IsDisposed)
                this.OutlineForm = new OutlineForm(active,this.OutlineAnalyzePattern);
            this.editor.Show(this.OutlineForm, DockingType.DockLeft);
        }
    }
}
