﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel.Composition;
using FooEditEngine;
using FooEditEngine.Windows;
using FooEditor;
using FooEditor.Plugin;
using System.Windows.Forms;

namespace AutoIndent
{
    [Export(typeof(IPlugin))]
    public class Main : IPlugin
    {
        string[] IntendStart,IntendEnd;

        public void Initalize(Editor e)
        {
            e.CreatedEditFromEvent += new CreateEditFormEventHandler(e_CratedEditFromEvent);
        }

        void e_CratedEditFromEvent(object sender, EditFormEventArgs e)
        {
            e.edit.fooTextBox1.KeyPress +=new KeyPressEventHandler(fooTextBox1_KeyPress);
            e.edit.DocumentChangeTypeEvent += new FooEditor.DocumentTypeChangeEventHandler(edit_DocumentChangeTypeEvent);
        }

        void edit_DocumentChangeTypeEvent(object sender, EventArgs e)
        {
            EditForm edit = (EditForm)sender;
            this.IntendStart = edit.SynataxDefnition.IntendStart;
            this.IntendEnd = edit.SynataxDefnition.IntendEnd;
        }

        void fooTextBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            FooTextBox TextBox = (FooTextBox)sender;

            StringBuilder temp = new StringBuilder();
            
            if (e.KeyChar == '\r')
            {
                TextPoint cur = TextBox.LayoutLines.GetTextPointFromIndex(TextBox.SelectionStart);
                int lineNumber = cur.row;

                string lineString = TextBox.LayoutLines[lineNumber];

                int tabNum = this.GetIntendLevel(lineString);

                if (hasWords(lineString, IntendEnd))
                    tabNum--;
                else if (hasWords(lineString, IntendStart))
                    tabNum++;

                if (tabNum < 0 || cur.col == 0)
                    tabNum = 0;
                else if (cur.col < tabNum)
                    tabNum -= cur.col;

                for (int i = 0; i < tabNum; i++)
                    temp.Append('\t');

                if (temp.Length > 0)
                {
                    temp.Insert(0, Document.NewLine);
                    TextBox.SelectedText = temp.ToString();
                }

                TextBox.Refresh();

                if (tabNum > 0)
                    e.Handled = true;
            }
        }

        bool hasWords(string s, IList<string> words)
        {
            if (words == null)
                return false;
            foreach (string word in words)
                if (s.IndexOf(word) != -1)
                    return true;
            return false;
        }

        int GetIntendLevel(string s)
        {
            int level = 0;
            for (int i = 0; i < s.Length; i++)
            {
                if (s[i] != '\t')
                    break;
                level++;
            }
            return level;
        }

        public void ClosedApp()
        {
            return;
        }

        public void ShowConfigForm()
        {
            return;
        }
    }
}
