﻿using System;
#if WPF
using FooEditEngine.WPF;
#endif
#if METRO
using FooEditEngine.Metro;
#endif

namespace FooEditor
{
    class LineJumpViewModel : ViewModelBase
    {
        FooTextBox Textbox;
        int _ToRow, _MaxRow;
        string _Result;
        public LineJumpViewModel(FooTextBox textbox)
        {
            this.Textbox = textbox;
            this.ToRow = textbox.CaretPostion.row + 1;
            this.MaxRow = textbox.LayoutLineCollection.Count;
        }
        public int ToRow
        {
            get
            {
                return this._ToRow;
            }
            set
            {
                this._ToRow = value;
                this.OnPropertyChanged();
            }
        }
        public int MaxRow
        {
            get
            {
                return this._MaxRow;
            }
            set
            {
                this._MaxRow = value;
                this.OnPropertyChanged();
            }
        }
        public string Result
        {
            get
            {
                return this._Result;
            }
            set
            {
                this._Result = value;
                this.OnPropertyChanged();
            }
        }
        public bool JumpCaretCommand()
        {
            this.Result = string.Empty;
            if (this._ToRow <= 0 || this._ToRow > this._MaxRow)
                return true;
            this.Textbox.JumpCaret(this._ToRow - 1, 0);
            this.Textbox.Refresh();
            return false;
        }
    }
}
