﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.IO;
using FooEditor;

namespace SinnpetPlugin
{
    public partial class SinppetDialog : Form
    {
        const string SnippetFolderName = "Sinppets";
        private List<SinppetCollection> list = new List<SinppetCollection>();
        private SinppetCollection data;
        private Config cfg = Config.GetInstance();

        public SinppetDialog()
        {
            InitializeComponent();

            this.SelectedText = null;
            
            string[] filelist = Directory.GetFiles(Path.Combine(Application.StartupPath,SnippetFolderName));
            for (int i = 0; i < filelist.Length; i++)
                this.comboBox1.Items.Add(Path.GetFileName(filelist[i]));

            if (Directory.Exists(Path.Combine(Config.ApplicationFolder, SnippetFolderName)))
            {
                filelist = Directory.GetFiles(Path.Combine(Config.ApplicationFolder, SnippetFolderName));
                for (int i = 0; i < filelist.Length; i++)
                {
                    if (this.comboBox1.Items.Contains(Path.GetFileName(filelist[i])) == false)
                        this.comboBox1.Items.Add(Path.GetFileName(filelist[i]));
                }
            }
        }

        /// <summary>
        /// 選択された文字列
        /// </summary>
        public string SelectedText
        {
            get;
            private set;
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            string item = (string)this.comboBox1.SelectedItem;
            this.comboBox2.Items.Clear();

            string filepath = Path.Combine(Config.ApplicationFolder, SnippetFolderName, item);
            if(File.Exists(filepath) == false)
                filepath = Path.Combine(Application.StartupPath, SnippetFolderName, item);
            
            this.data = new SinppetCollection(filepath);
            foreach (string k in this.data.Keys)
                this.comboBox2.Items.Add(k);
        }

        private void comboBox2_SelectedIndexChanged(object sender, EventArgs e)
        {
            string key = this.comboBox2.SelectedItem.ToString();
            this.textBox1.Text = this.data[key];
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.SelectedText = this.textBox1.Text;
            this.Close();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

    }
}
