﻿using System;
using System.Collections.Generic;

namespace FooEditor
{
    enum RecentFileUpdateType
    {
        Add,
        Insert,
        Remove,
        Clear,
    }

    class RecentFileUpdateArgs : EventArgs
    {
        public string lastUpdatedPath;
        public RecentFileUpdateType type;
        public RecentFileUpdateArgs(string path,RecentFileUpdateType type)
        {
            this.lastUpdatedPath = path;
            this.type = type;
        }
    }

    delegate void RecentFileUpdateEvent(object sender, RecentFileUpdateArgs e);
    
    class RecentFileCollection : IEnumerable<string>
    {
        List<string> list;

        public RecentFileCollection()
        {
            this.list = list = new List<string>();
            this.RecentFileUpdateEventHandler += new RecentFileUpdateEvent((s,e)=>{});
        }

        public event RecentFileUpdateEvent RecentFileUpdateEventHandler;

        public int Count
        {
            get { return this.list.Count; }
        }

        public int MaxCount
        {
            get;
            set;
        }

        public void InsertAtFirst(string filepath)
        {
            this.list.Remove(filepath);
            this.RecentFileUpdateEventHandler(this, new RecentFileUpdateArgs(filepath, RecentFileUpdateType.Remove));
            if (this.list.Count >= this.MaxCount)
            {
                this.RecentFileUpdateEventHandler(this, new RecentFileUpdateArgs(this.list[this.list.Count - 1], RecentFileUpdateType.Remove));
                this.list.RemoveAt(this.list.Count - 1);
            }
            this.list.Insert(0, filepath);
            this.RecentFileUpdateEventHandler(this, new RecentFileUpdateArgs(filepath, RecentFileUpdateType.Insert));
        }

        public void Add(string filepath)
        {
            if (this.list.Count >= this.MaxCount)
                return;
            this.list.Add(filepath);
            this.RecentFileUpdateEventHandler(this, new RecentFileUpdateArgs(filepath,RecentFileUpdateType.Add));
        }

        public void AddRange(IEnumerable<string> collction)
        {
            foreach (string s in collction)
                this.Add(s);
        }

        public void Clear()
        {
            this.list.Clear();
            this.RecentFileUpdateEventHandler(this, new RecentFileUpdateArgs(string.Empty, RecentFileUpdateType.Clear));
        }

        public string[] ToArray()
        {
            return this.list.ToArray();
        }

        #region IEnumerable<string> メンバー

        public IEnumerator<string> GetEnumerator()
        {
            foreach (string s in this.list)
                yield return s;
        }

        #endregion

        #region IEnumerable メンバー

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            throw new NotImplementedException();
        }

        #endregion
    }
}
