﻿using System;

namespace FooEditEngine
{
    class PrintableView : View
    {
        new IPrintableTextRender render;

        public PrintableView(Document doc,IPrintableTextRender r)
            : base (doc,r,0)
        {
            this.render = r;
        }

        public string Header
        {
            get;
            set;
        }

        public string Footer
        {
            get;
            set;
        }

        public override void Draw(Rectangle updateRect)
        {
            if (this.LayoutLines.Count == 0)
                return;

            if (this.Hilighter != null)
                this.Hilighter.Reset();

            Point pos = base.PageBound.Location;
            pos.X -= Src.X;

            int endRow = Math.Min(this.LayoutLines.Count - 1, Src.Row + this.LineCountOnScreen - 1);

            //ヘッダーを印刷する
            if (this.Header != null && this.Header != string.Empty)
            {
                this.render.DrawString(this.Header, pos.X, pos.Y, StringAlignment.Center);

                pos.Y += (int)this.render.HeaderHeight;
            }

            //レイアウト行を印刷する
            for (int i = Src.Row; i <= endRow; i++)
            {
                double lineHeight = this.LayoutLines.GetData(i).Layout.Height;

                this.render.DrawOneLine(this.LayoutLines,i, pos.X + this.render.ClipRect.X, pos.Y, null);

                if (this.DrawLineNumber)
                    this.render.DrawLineNumber(i, this.PageBound.X, pos.Y);

                pos.Y += lineHeight;
            }

            //フッターを印刷する
            if (this.Footer != null && this.Footer != string.Empty)
            {
                this.render.DrawString(this.Footer, pos.X, pos.Y, StringAlignment.Center);

                pos.Y += (int)this.render.FooterHeight;
            }
        }

        public bool TryPageDown()
        {
            return base.TryScroll(this.Src.X, this.Src.Row + this.LineCountOnScreen);
        }

        protected override void CalculateLineCountOnScreen()
        {
            if (this.LayoutLines.Count == 0)
                return;

            double y = 0;
            int i = this.Src.Row;
            for (; true; i++)
            {
                LineToIndexTableData lineData = i < this.LayoutLines.Count ?
                    this.LayoutLines.GetData(i) :
                    this.LayoutLines.GetData(this.LayoutLines.Count - 1);

                ITextLayout layout = lineData.Layout;

                double lineHeight = layout.Height;

                y += lineHeight;

                if (y >= this.PageBound.Height)
                    break;
            }
            this.LineCountOnScreen = Math.Max(i - this.Src.Row - 1, 0);

            if (this.Footer != null && this.Footer != string.Empty)
                this.LineCountOnScreen--;
            if (this.Header != null && this.Header != string.Empty)
                this.LineCountOnScreen--;
        }
    }
}
