﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FooEditEngine
{
    class ResourceManager<TKey, TValue> : Dictionary<TKey, TValue>
    {
        /// <summary>
        /// 任意のキーに関連づけられてる値を削除する
        /// </summary>
        /// <param name="key">キー</param>
        /// <returns>IDispseableを継承している場合、Dispose()が呼び出されます</returns>
        public new bool Remove(TKey key)
        {
            TValue value;
            bool result = base.TryGetValue(key, out value);
            if (value is IDisposable)
                ((IDisposable)value).Dispose();
            if (result)
                base.Remove(key);
            return result;
        }
        /// <summary>
        /// すべて削除する
        /// </summary>
        /// <remarks>IDispseableを継承している場合、Dispose()が呼び出されます</remarks>
        public new void Clear()
        {
            if (this.Count == 0)
                return;
            TValue first = this.Values.First();
            if (first is IDisposable)
            {
                foreach (IDisposable v in this.Values)
                    v.Dispose();
            }
            base.Clear();
        }
    }
}
