﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using DWriteWarpper;

namespace FooEditEngine.WPF.Direct2D
{
    interface IMarkerEffecter
    {
        void Apply(DRenderBase render, DTextLayout layout, int index, int length, double x, double y);
    }

    class SquilleLineMarker : IMarkerEffecter
    {
        DColorBrush brush;
        DStrokeStyle stroke;
        float thickness;
        public SquilleLineMarker(DDrawingEffect effect, float thickness)
        {
            this.brush = effect.Fore;
            this.stroke = effect.Underline;
            this.thickness = thickness;
        }
        public void Apply(DRenderBase render,DTextLayout layout, int start, int length,double x, double y)
        {
            render.AntialiasMode = DAntialias.Alias;

            DHitTestMetrics[] metrics = layout.HitTestTextRange(start, length, (float)x, (float)y);
            foreach (DHitTestMetrics metric in metrics)
            {
                this.DrawSquilleLine(render, metric.left, metric.top, metric.width, metric.height);
            }

            render.AntialiasMode = DAntialias.Antialias;
        }

        void DrawSquilleLine(DRenderBase render,float x,float y,float width,float height)
        {
            float lineWidthSize = Util.RoundUp(height / 24) + 1;
            float lineLength = lineWidthSize + (lineWidthSize * 4);
            float waveHeight = Util.RoundUp(height / 12) + 1;
            float lineSpacing = lineWidthSize * 8;
            float offsetX = x % (waveHeight * 2);

            float valleyY = Util.RoundUp(y + height);
            float ridgeY = valleyY - waveHeight;
            float endX = x + width - 1;
            for (x = x - offsetX; x < endX; x += (waveHeight * 2))
            {
                float ridgeX = x + waveHeight;
                float valleyX = ridgeX + waveHeight;
                if (ridgeX <= endX)
                    render.DrawLine(new Point2F(x, valleyY), new Point2F(ridgeX, ridgeY), this.thickness, this.brush, this.stroke);
                if (valleyX <= endX)
                    render.DrawLine(new Point2F(ridgeX, ridgeY),new Point2F(valleyX, valleyY),this.thickness,this.brush,this.stroke);
            }
        }
    }

    class LineMarker : IMarkerEffecter
    {
        DColorBrush brush;
        DStrokeStyle stroke;
        float thickness;
        public LineMarker(DDrawingEffect effect,float thickness)
        {
            this.brush = effect.Fore;
            this.stroke = effect.Underline;
            this.thickness = thickness;
        }

        public void Apply(DRenderBase render,DTextLayout layout, int start, int length,double x, double y)
        {
            render.AntialiasMode = DAntialias.Alias;

            DHitTestMetrics[] metrics = layout.HitTestTextRange(start, length, (float)x, (float)y);
            foreach (DHitTestMetrics metric in metrics)
            {
                render.DrawLine(new Point2F(metric.left, metric.top + metric.height),
                    new Point2F(metric.left + metric.width - 1, metric.top + metric.height),
                    this.thickness,
                    this.brush,
                    this.stroke);
            }

            render.AntialiasMode = DAntialias.Antialias;
        }
    }

    class HilightMarker : IMarkerEffecter
    {
        DColorBrush brush;
        public HilightMarker(DColorBrush brush)
        {
            this.brush = brush;
        }

        public void Apply(DRenderBase render,DTextLayout layout, int start, int length, double x, double y)
        {
            render.AntialiasMode = DAntialias.Alias;

            DHitTestMetrics[] metrics = layout.HitTestTextRange(start, length, (float)x, (float)y);
            foreach (DHitTestMetrics metric in metrics)
            {
                render.FillRectangle(new RectF(metric.left, metric.top, metric.left + metric.width, metric.top + metric.height),brush);
            }

            render.AntialiasMode = DAntialias.Antialias;
        }
    }
}
