﻿using System;
using System.Collections.Generic;
using System.Linq;
using FooEditEngine;

namespace Test
{
    class CharFoldingMethod : IFoldingStrategy
    {
        public CharFoldingMethod(char begin, char end)
        {
            this.BeginChar = begin;
            this.EndChar = end;
        }

        public char BeginChar
        {
            get;
            set;
        }
        
        public char EndChar
        {
            get;
            set;
        }

        public IEnumerable<FoldingItem> AnalyzeDocument(Document doc, int start, int end)
        {
            Stack<int> BeginIndexColletion = new Stack<int>();
            for (int i = start; i <= end; i++)
            {
                if (doc[i] == this.BeginChar)
                    BeginIndexColletion.Push(i);
                if (doc[i] == this.EndChar)
                {
                    if (BeginIndexColletion.Count == 0)
                        continue;
                    int beginIndex = BeginIndexColletion.Pop();
                    if (beginIndex < i)
                    {
                        yield return new FoldingItem(beginIndex, i);
                    }
                }
            }
        }
    }
}
