﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FooEditEngine
{
    enum GripperType
    {
        First,
        Second,
    }
    class GripperManager
    {
        Controller Controller;
        EditView View;
        D2DRender Render;
        public GripperManager(Controller controller, EditView view,D2DRender render)
        {
            this.Controller = controller;
            this.View = view;
            this.Render = render;
            this.Enabled = false;
        }

        public bool Enabled
        {
            get;
            set;
        }

        public Rectangle HitTest(GripperType type,Point p)
        {
            Rectangle gripperRect = this.GetGripperPoint(type);
            if (this.Enabled && gripperRect.IsHit(p))
                return gripperRect;
            return Rectangle.Empty;
        }

        public Rectangle GetGripperPoint(GripperType type)
        {
            TextPoint tp;
            Point point;
            double radius = D2DRender.CramToFitWidth / 2;
            if (type == GripperType.Second)
            {
                tp = this.View.LayoutLines.GetTextPointFromIndex(this.Controller.SelectionStart + this.Controller.SelectionLength);
                point = this.View.GetPostionFromTextPoint(tp);
                double lineHeight = this.View.LayoutLines.GetData(tp.row).Layout.Height;
                return new Rectangle(point.X - radius, point.Y + lineHeight, D2DRender.CramToFitWidth, D2DRender.CramToFitWidth);
            }
            else if (type == GripperType.First)
            {
                tp = this.View.LayoutLines.GetTextPointFromIndex(this.Controller.SelectionStart);
                point = this.View.GetPostionFromTextPoint(tp);
                return new Rectangle(point.X - radius, point.Y - D2DRender.CramToFitWidth, D2DRender.CramToFitWidth, D2DRender.CramToFitWidth);
            }
            else
            {
                throw new ArgumentOutOfRangeException();
            }
        }

        public Point GetPointOnGripper(GripperType type,Rectangle gripperRect, Point p)
        {
            if (type == GripperType.First)
            {
                if (gripperRect.IsHit(p))
                    p.Y = gripperRect.Bottom + 1;
                else
                    p.Y += gripperRect.Height;
            }
            else
            {
                if (gripperRect.IsHit(p))
                    p.Y = gripperRect.Y - 1;
                else
                    p.Y -= gripperRect.Height;
            }
            if (p.Y < this.Render.TextArea.Y)
                p.Y = this.Render.TextArea.Y;
            return p;
        }

        public void DrawGrippers()
        {
            if (!this.Enabled)
                return;
            DrawGripper(GripperType.First);
            DrawGripper(GripperType.Second);
        }
        void DrawGripper(GripperType type)
        {
            Rectangle gripperRect = GetGripperPoint(type);
            double radius = gripperRect.Width / 2;
            Point point;
            if(type == GripperType.First)
                point = new Point(gripperRect.X + radius, gripperRect.Y + radius);
            else
                point = new Point(gripperRect.X + radius, gripperRect.Y + radius);
            this.Render.DrawGripper(point, radius);
        }
    }
}
