﻿using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Media;
using FooEditEngine;
using FooEditEngine.WPF;
using Microsoft.Win32;

namespace Test
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            this.fooTextBox.Hilighter = new XmlHilighter();
            this.fooTextBox.MouseDoubleClick += new System.Windows.Input.MouseButtonEventHandler(fooTextBox_MouseDoubleClick);
            this.fooTextBox.ShowTab = true;
            this.fooTextBox.ShowFullSpace = true;
        }

        void fooTextBox_MouseDoubleClick(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            FooMouseButtonEventArgs fe = (FooMouseButtonEventArgs)e;
            foreach (Marker m in this.fooTextBox.Document.GetMarkers(fe.Index))
            {
                if (m.hilight == HilightType.Url)
                {
                    MessageBox.Show(this.fooTextBox.Document.ToString(m.start, m.length));

                    fe.Handled = true;
                }
            }
        }

        private void MenuItem_Click(object sender, RoutedEventArgs e)
        {
            this.fooTextBox.IsEnabled = true;
            this.fooTextBox.Refresh();
        }

        private void MenuItem_Click_1(object sender, RoutedEventArgs e)
        {
            this.fooTextBox.IsEnabled = false;
            this.fooTextBox.Refresh();
        }

        private void MenuItem_Click_2(object sender, RoutedEventArgs e)
        {
            PrintDialog pd = new PrintDialog();
            pd.PageRangeSelection = PageRangeSelection.AllPages;
            pd.UserPageRangeEnabled = true;
            if (pd.ShowDialog() == false)
                return;
            FooPrintText printtext = new FooPrintText();
            printtext.Document = this.fooTextBox.Document;
            printtext.Font = this.fooTextBox.FontFamily;
            printtext.FontSize = this.fooTextBox.FontSize;
            printtext.DrawLineNumber = true;
            printtext.Header = "header";
            printtext.Footer = "footter";
            printtext.isWordRap = true;
            printtext.MarkURL = true;
            printtext.Hilighter = this.fooTextBox.Hilighter;
            printtext.Foreground = new SolidColorBrush(this.fooTextBox.Foreground);
            printtext.URL = new SolidColorBrush(this.fooTextBox.URL);
            printtext.Comment = new SolidColorBrush(this.fooTextBox.Comment);
            printtext.Keyword1 = new SolidColorBrush(this.fooTextBox.Keyword1);
            printtext.Keyword2 = new SolidColorBrush(this.fooTextBox.Keyword2);
            printtext.Litral = new SolidColorBrush(this.fooTextBox.Literal);
            if (pd.PageRangeSelection == PageRangeSelection.AllPages)
            {
                printtext.StartPage = -1;
                printtext.EndPage = -1;
            }
            else
            {
                printtext.StartPage = pd.PageRange.PageFrom;
                printtext.EndPage = pd.PageRange.PageTo;
            }
            printtext.PageRect = new Rect(0,0,pd.PrintableAreaWidth, pd.PrintableAreaHeight);
            printtext.Print(pd.PrintQueue,pd.PrintTicket);
        }

        private void MenuItem_Click_3(object sender, RoutedEventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            bool result = (bool)ofd.ShowDialog(this);
            if (result == true)
            {
                this.fooTextBox.Document.Load(ofd.FileName, Encoding.Default);
                this.fooTextBox.Refresh();
            }
        }

        private void MenuItem_Click_4(object sender, RoutedEventArgs e)
        {
            this.fooTextBox.WordRap = this.WordRap.IsChecked;
            this.fooTextBox.Refresh();
        }
    }
}
