﻿using System;
using System.Globalization;
using System.Collections.Generic;
using System.Text;

namespace FooEditEngine
{
    class Util
    {
        public static bool IsWordSeparator(char c)
        {
            if (c == Document.NewLine || char.IsSeparator(c) || char.IsPunctuation(c) || char.GetUnicodeCategory(c) == UnicodeCategory.MathSymbol)
                return true;
            else
                return false;
        }
        public static void Swap<T>(ref T a, ref T b)
        {
            T c = b;
            b = a;
            a = c;
        }

        public static string Generate(char c, int count)
        {
            StringBuilder tabstr = new StringBuilder();
            for (int j = count; j > 0; j--)
                tabstr.Append(c);
            return tabstr.ToString();
        }

        public static Rectangle OffsetAndDeflate(Rectangle r, Size s)
        {
            return new Rectangle(r.X + s.Width,r.Y + s.Height, r.Width - s.Width, r.Height - s.Height);
        }

        public static IEnumerable<string> GetLines<T>(T doc, int startIndex, int endIndex,int maxCharCount = -1) where T : IRandomEnumrator<char>
        {
            StringBuilder line = new StringBuilder();
            for (int i = startIndex; i <= endIndex; i++)
            {
                char c = doc[i];
                line.Append(c);
                if (c == Document.NewLine || 
                    (maxCharCount != -1 && line.Length >= maxCharCount))
                {
                    yield return line.ToString();
                    line.Clear();
                }
            }
            if (line.Length > 0)
                yield return line.ToString();
        }

        public static T NormalizeIMaker<T>(T m) where T : IMarker
        {
            if (m.length > 0)
                return m;
            m.start = m.start + m.length;
            m.length = Math.Abs(m.length);
            return m;
        }

        public static int RoundUp(float x)
        {
            return (int)(x + 0.5);
        }
    }
}
