#include "StdAfx.h"
#include "Common.h"
#include "DrawingEffect.h"


/******************************************************************
*                                                                 *
*  DrawingEffect::DrawingEffect                         *
*                                                                 *
*                                                                 *
*                                                                 *
******************************************************************/

DrawingEffect::DrawingEffect()
{
	cRefCount_ = 0;
}

/******************************************************************
*                                                                 *
*  DrawingEffect::DrawingEffect                         *
*                                                                 *
*                                                                 *
*                                                                 *
******************************************************************/

DrawingEffect::DrawingEffect(ID2D1SolidColorBrush* foreBrush,ID2D1SolidColorBrush* backBrush,ID2D1StrokeStyle* underline)
{
	if(foreBrush == NULL)
		throw "foreBrush can't be null";

	cRefCount_ = 0;

	this->foreBrush = foreBrush;
	this->foreBrush->AddRef();

	this->backBrush = backBrush;
	if(this->backBrush != NULL)
		this->backBrush->AddRef();

	this->underline = underline;
	if(this->underline != NULL)
		this->underline->AddRef();
}

/******************************************************************
*                                                                 *
*  DrawingEffect::~DrawingEffect                        *
*                                                                 *
*                                                                 *
*                                                                 *
******************************************************************/


DrawingEffect::~DrawingEffect()
{
	::SafeRelease(&foreBrush);
	::SafeRelease(&backBrush);
	::SafeRelease(&underline);
}

/******************************************************************
*                                                                 *
*  DrawingEffect::GetForeColor                               *
*                                                                 *
*                                                                 *
*                                                                 *
******************************************************************/

STDMETHODIMP DrawingEffect::GetForeColor(ID2D1SolidColorBrush** foreBrush)
{
    *foreBrush = this->foreBrush;

    return S_OK;
}

/******************************************************************
*                                                                 *
*  DrawingEffect::GetBackColor                               *
*                                                                 *
*                                                                 *
*                                                                 *
******************************************************************/

STDMETHODIMP DrawingEffect::GetBackColor(ID2D1SolidColorBrush** backBrush)
{
    *backBrush = this->backBrush;

    return S_OK;
}

STDMETHODIMP DrawingEffect::GetUnderLine(ID2D1StrokeStyle** underline)
{
	*underline = this->underline;

	return S_OK;
}

/******************************************************************
*                                                                 *
*  DrawingEffect::AddRef                                     *
*                                                                 *
*  Increments the ref count                                       *
*                                                                 *
******************************************************************/

STDMETHODIMP_(unsigned long) DrawingEffect::AddRef()
{
    return InterlockedIncrement(&cRefCount_);
}

/******************************************************************
*                                                                 *
*  DrawingEffect::Release                                    *
*                                                                 *
*  Decrements the ref count and deletes the instance if the ref   *
*  count becomes 0                                                *
*                                                                 *
******************************************************************/

STDMETHODIMP_(unsigned long) DrawingEffect::Release()
{
    unsigned long newCount = InterlockedDecrement(&cRefCount_);
    
    if (newCount == 0)
    {
        delete this;
        return 0;
    }

    return newCount;
}

/******************************************************************
*                                                                 *
*  DrawingEffect::QueryInterface                             *
*                                                                 *
*  Query interface implementation                                 *
*                                                                 *
******************************************************************/

STDMETHODIMP DrawingEffect::QueryInterface(
    IID const& riid,
    void** ppvObject
    )
{
    if (__uuidof(DrawingEffect) == riid)
    {
        *ppvObject = this;
    }
    else if (__uuidof(IUnknown) == riid)
    {
        *ppvObject = this;
    }
    else
    {
        *ppvObject = NULL;
        return E_FAIL;
    }

    AddRef();

    return S_OK;
}
