#include "DDrawingEffect.h"

using namespace DWriteWarpper;

DDrawingEffect::DDrawingEffect(DrawingEffect* dwEffect)
{
	effect = dwEffect;

	ID2D1SolidColorBrush* brush;

	effect->GetForeColor(&brush);
	brush->AddRef();
	_foreBrush = gcnew DColorBrush(brush);

	effect->GetBackColor(&brush);
	brush->AddRef();
	_backBrush = gcnew DColorBrush(brush);

	disposed = false;
}

DrawingEffect* DDrawingEffect::dwEffect::get() { return this->effect; }

DColorBrush^ DDrawingEffect::Fore::get() { return this->_foreBrush; }

DColorBrush^ DDrawingEffect::Back::get() { return this->_backBrush; }

DStrokeStyle^ DDrawingEffect::Underline::get() { return this->_underline; }

DDrawingEffect::DDrawingEffect(DColorBrush^ Fore,DColorBrush^ Back,DStrokeStyle^ Underline)
{
	_foreBrush = Fore;
	_backBrush = Back;
	_underline = Underline;
	effect = new DrawingEffect(_foreBrush->brush,_backBrush == nullptr ? NULL : _backBrush->brush,Underline == nullptr ? NULL : Underline->stroke);
	effect->AddRef();
	disposed = false;
}

DDrawingEffect::~DDrawingEffect()
{
	GC::SuppressFinalize(this);
	this->!DDrawingEffect();
}

DDrawingEffect::!DDrawingEffect()
{
	if(disposed)
		return;
	int cRefCount = effect->Release();
	delete _foreBrush;
	if(_backBrush == nullptr)
		delete _backBrush;
	if(_underline == nullptr)
		delete _underline;
	disposed = true;
}
