#pragma once

#include "StdAfx.h"
#include "Common.h"
#include "DTextLayout.h"
#include "Util.h"

using namespace System;

namespace DWriteWarpper {

	ref class DDrawingEffect;	//zQƑ΍
	ref class DColorBrush;

	public value struct DwriteTextRange
	{
	public:
		unsigned int start;
		unsigned int length;
	internal:
		void CopyFrom(DWRITE_TEXT_RANGE *metrics);
	};

	public value struct DLineMetrics
	{
	public:
		unsigned int length;
		unsigned int trailingWhitespaceLength;
		unsigned int newlineLength;
		float  height;
		float  baseline;
		bool   isTrimmed;
	internal:
		void CopyFrom(DWRITE_LINE_METRICS *metrics);
	};

	public value struct DTextMetrics
	{
	public:
		  float  left;
		  float  top;
		  float  width;
		  float  widthIncludingTrailingWhitespace;
		  float  height;
		  float  layoutWidth;
		  float  layoutHeight;
		  unsigned int maxBidiReorderingDepth;
	internal:
		void CopyFrom(DWRITE_TEXT_METRICS *metrics);
	};

	public value struct DHitTestMetrics
	{
	public:
		  unsigned int textPosition;
		  unsigned int length;
		  float  left;
		  float  top;
		  float  width;
		  float  height;
		  unsigned int bidiLevel;
		  bool   isText;
          bool	isTrimmed;
	internal:
		void CopyFrom(DWRITE_HIT_TEST_METRICS *metrics);
	};

	public ref class DTextLayout
	{
	private:
		IDWriteTextLayout* pTextLayout_;
		bool disposed;
	internal:
		DTextLayout(IDWriteTextLayout* layout);

		property IDWriteTextLayout* dwTextLayout
		{
			IDWriteTextLayout* get();
		}

	public:
		property DTextMetrics metrics
		{
			DTextMetrics get();
		}

		property Object^ Tag;

		property array<DLineMetrics>^ LineMetrics
		{
			array<DLineMetrics>^ get();
		}

		DHitTestMetrics HitTestTextPostion(int index,bool isTrailingHit,[System::Runtime::InteropServices::Out] float% x,[System::Runtime::InteropServices::Out] float% y);

		DHitTestMetrics HitTextPoint(float x,float y,[System::Runtime::InteropServices::Out] bool% isTrailingHit,[System::Runtime::InteropServices::Out] bool% isInside);

		array<DHitTestMetrics>^ HitTestTextRange(int index,int length,float originx,float originy);

		void SetTextEffect(int index,int length,DDrawingEffect^ effect);

		void SetTextEffect(int index,int length,DColorBrush^ effect);

		void SetUnderline(int index,int length,bool hasLine);

		~DTextLayout(void);

		!DTextLayout();
	};
}
