#include "DTextLayout.h"
#include "DDrawingEffect.h"

using namespace DWriteWarpper;
using namespace System::ComponentModel;

void DwriteTextRange::CopyFrom(DWRITE_TEXT_RANGE *range)
{
	this->start = range->startPosition;
	this->length = range->length;
}

void DLineMetrics::CopyFrom(DWRITE_LINE_METRICS *metrics)
{
	this->length = metrics->length;
	this->trailingWhitespaceLength = metrics->trailingWhitespaceLength;
	this->newlineLength = metrics->newlineLength;
	this->height = metrics->height;
	this->baseline = metrics->baseline;
	this->isTrimmed = metrics->isTrimmed == TRUE;
}

void DTextMetrics::CopyFrom(DWRITE_TEXT_METRICS *metrics)
{
	this->left = metrics->left;
	this->top = metrics->top;
	this->width = metrics->width;
	this->widthIncludingTrailingWhitespace = metrics->widthIncludingTrailingWhitespace;
	this->height = metrics->height;
	this->layoutWidth = metrics->layoutWidth;
	this->layoutHeight = metrics->layoutHeight;
	this->maxBidiReorderingDepth = metrics->maxBidiReorderingDepth;
}

void DHitTestMetrics::CopyFrom(DWRITE_HIT_TEST_METRICS *metrics)
{
	this->textPosition = metrics->textPosition;
	this->length = metrics->length;
	this->left = metrics->left;
	this->top = metrics->top;
	this->width = metrics->width;
	this->height = metrics->height;
	this->bidiLevel = metrics->bidiLevel;
	this->isText = metrics->isText == TRUE;
	this->isTrimmed = metrics->isTrimmed == TRUE;
}

DTextLayout::DTextLayout(IDWriteTextLayout* layout)
{
	if(layout == NULL)
		throw gcnew ArgumentNullException("layout is NULL");
	pTextLayout_ = layout;
	disposed = false;
}

IDWriteTextLayout* DTextLayout::dwTextLayout::get() 
{
	return this->pTextLayout_;
}


DTextMetrics DTextLayout::metrics::get()
{
	DWRITE_TEXT_METRICS metrics;
	pTextLayout_->GetMetrics(&metrics);
	DTextMetrics result;
	result.CopyFrom(&metrics);
	return result;
}

array<DLineMetrics>^ DTextLayout::LineMetrics::get()
{
	UINT32 count = 0;

	pTextLayout_->GetLineMetrics(NULL,count,&count);

	array<DLineMetrics>^ results = gcnew array<DLineMetrics>(count);
	pin_ptr<DLineMetrics> resultsPtr = &results[0];
	pTextLayout_->GetLineMetrics((DWRITE_LINE_METRICS*)resultsPtr,count,&count);

	return results;
}

DHitTestMetrics DTextLayout::HitTestTextPostion(int index,bool isTrailingHit,[System::Runtime::InteropServices::Out] float% x,[System::Runtime::InteropServices::Out] float% y)
{
	float xCopy,yCopy;
	DWRITE_HIT_TEST_METRICS metrics;

	HRESULT hr;
	hr = pTextLayout_->HitTestTextPosition(index,isTrailingHit,&xCopy,&yCopy,&metrics);
	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"HitTextPostion Error");

	x = xCopy;
	y = yCopy;
	DHitTestMetrics result;
	result.CopyFrom(&metrics);

	return result;
}

DHitTestMetrics DTextLayout::HitTextPoint(float x,float y,[System::Runtime::InteropServices::Out] bool% isTrailingHit,[System::Runtime::InteropServices::Out] bool% isInside)
{
	BOOL isTrailingHitCopy,isInsideCopy;
	DWRITE_HIT_TEST_METRICS metrics;

	HRESULT hr;
	hr = pTextLayout_->HitTestPoint(x,y,&isTrailingHitCopy,&isInsideCopy,&metrics);
	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"HitTestPoint Error");

	isTrailingHit = isTrailingHitCopy != 0;
	isInsideCopy = isInside != 0;
	DHitTestMetrics result;
	result.CopyFrom(&metrics);

	return result;
}

array<DHitTestMetrics>^ DTextLayout::HitTestTextRange(int index,int length,float originx,float originy)
{
	HRESULT hr;
	UINT32 count = 0;
	pTextLayout_->HitTestTextRange(index,length,originx,originy,NULL,count,&count);

	DWRITE_HIT_TEST_METRICS* metrics = new DWRITE_HIT_TEST_METRICS[count];
	array<DHitTestMetrics>^ output = gcnew array<DHitTestMetrics>(count);
	hr = pTextLayout_->HitTestTextRange(index,length,originx,originy,metrics,count,&count);
	if(hr != S_OK)
	{
		delete metrics;
		throw gcnew Win32Exception(hr,"HitTestRange Error");
	}
	for(int i = 0; i < count; i++)
		output[i].CopyFrom(&metrics[i]);
	delete metrics;
	return output;
}

void DTextLayout::SetTextEffect(int index,int length,DDrawingEffect^ effect)
{
	HRESULT hr;
	DWRITE_TEXT_RANGE textRange = {index,length};
	hr = pTextLayout_->SetDrawingEffect(effect->dwEffect, textRange);
	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"SetDraingEffect Error");
}

void DTextLayout::SetTextEffect(int index,int length,DColorBrush^ effect)
{
	HRESULT hr;
	DWRITE_TEXT_RANGE textRange = {index,length};
	hr = pTextLayout_->SetDrawingEffect(effect->brush, textRange);
	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"SetDraingEffect Error");
}

void DTextLayout::SetUnderline(int index,int length,bool hasLine)
{
	HRESULT hr;
	DWRITE_TEXT_RANGE textRange = {index,length};
	hr = pTextLayout_->SetUnderline(hasLine ? TRUE : FALSE, textRange);
	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"SetUnderline Error");
}

DTextLayout::~DTextLayout(void)
{
	GC::SuppressFinalize(this);
	this->!DTextLayout();
}

DTextLayout::!DTextLayout()
{
	if(disposed)
		return;
	if(DWriteWarpper::SafeRelease(pTextLayout_))
		pTextLayout_ = NULL;
	disposed = true;
}
