﻿using System;
using System.Text;
using System.IO;
using System.Threading.Tasks;

namespace FooEditEngine
{
    class WinFileWriter : IStreamWriter
    {
        StreamWriter sw;

#if !METRO
        public WinFileWriter(string filepath,Encoding enc)
        {
            this.sw = new StreamWriter(filepath,false, enc);
        }
#else
        public WinFileWriter(StreamWriter sw)
        {
            this.sw = sw;
        }
#endif
        
        public Task WriteAsync(string str)
        {
            return this.sw.WriteAsync(str);
        }

        public string NewLine
        {
            get
            {
                return this.sw.NewLine;
            }
            set
            {
                this.sw.NewLine = value;
            }
        }

        public void Close()
        {
#if !METRO
            this.sw.Close();
#else
#endif
        }
    }
    class WinFileReader : IStreamReader
    {
        TextReader sr;
#if !METRO
        public WinFileReader(string filepath, Encoding enc)
        {
            this.sr = new StreamReader(filepath, enc);
        }
        public WinFileReader(TextReader tr)
        {
            this.sr = tr;
        }
#else
        public WinFileReader(StreamReader sr)
        {
            this.sr = sr;
        }
#endif

        public bool IsEnd()
        {
            return this.sr.Peek() == -1;
        }

        public Task<string> ReadLineAsync()
        {
            return this.sr.ReadLineAsync();
        }

        public void Close()
        {
#if !METRO
            this.sr.Close();
#else
#endif
        }
    }
}
