﻿/*
 * Copyright (C) 2013 FooProject
 * * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using FooEditEngine;

namespace UnitTest
{
    [TestClass]
    public class UnitTest3
    {
        [TestMethod]
        public void InsertSingleLineTest()
        {
            Document doc = new Document();
            DummyRender render = new DummyRender();
            DummyView view = new DummyView(doc,render);
            doc.Clear();
            doc.Append("a\nb\nc\nd");
            Assert.IsTrue(view.LayoutLines[0] == "a\n" &&
                view.LayoutLines[1] == "b\n" &&
                view.LayoutLines[2] == "c\n" &&
                view.LayoutLines[3] == "d");

            doc.Insert(2, "x");
            Assert.IsTrue(view.LayoutLines[0] == "a\n" &&
                view.LayoutLines[1] == "xb\n" &&
                view.LayoutLines[2] == "c\n" &&
                view.LayoutLines[3] == "d");

            doc.Insert(3, "x");
            Assert.IsTrue(view.LayoutLines[0] == "a\n" &&
                view.LayoutLines[1] == "xxb\n" &&
                view.LayoutLines[2] == "c\n" &&
                view.LayoutLines[3] == "d");
            
            doc.Insert(6, "x");
            Assert.IsTrue(view.LayoutLines[0] == "a\n" &&
                view.LayoutLines[1] == "xxb\n" &&
                view.LayoutLines[2] == "xc\n" &&
                view.LayoutLines[3] == "d");
            
            doc.Insert(0, "x");
            Assert.IsTrue(view.LayoutLines[0] == "xa\n" &&
                view.LayoutLines[1] == "xxb\n" &&
                view.LayoutLines[2] == "xc\n" &&
                view.LayoutLines[3] == "d");

        }

        [TestMethod]
        public void InsertMultiLineTest()
        {
            Document doc = new Document();
            DummyRender render = new DummyRender();
            DummyView view = new DummyView(doc, render);

            doc.Clear();
            doc.Append("a\nb\nc\nd");

            doc.Insert(2, "f\ne");
            Assert.IsTrue(
                view.LayoutLines[0] == "a\n" &&
                view.LayoutLines[1] == "f\n" &&
                view.LayoutLines[2] == "eb\n" &&
                view.LayoutLines[3] == "c\n" &&
                view.LayoutLines[4] == "d");

            doc.Insert(3, "g\nh");
            Assert.IsTrue(
                view.LayoutLines[0] == "a\n" &&
                view.LayoutLines[1] == "fg\n" &&
                view.LayoutLines[2] == "h\n" &&
                view.LayoutLines[3] == "eb\n" &&
                view.LayoutLines[4] == "c\n" &&
                view.LayoutLines[5] == "d");

            doc.Insert(0, "x\ny");
            Assert.IsTrue(
                view.LayoutLines[0] == "x\n" &&
                view.LayoutLines[1] == "ya\n" &&
                view.LayoutLines[2] == "fg\n" &&
                view.LayoutLines[3] == "h\n" &&
                view.LayoutLines[4] == "eb\n" &&
                view.LayoutLines[5] == "c\n" &&
                view.LayoutLines[6] == "d");
        }

        [TestMethod]
        public void RemoveSingleLineTest()
        {
            Document doc = new Document();
            DummyRender render = new DummyRender();
            DummyView view = new DummyView(doc, render);
            doc.Clear();
            doc.Append("aa\nbb\ncc\ndd");

            doc.Remove(9, 1);
            Assert.IsTrue(
                view.LayoutLines[0] == "aa\n" && 
                view.LayoutLines[1] == "bb\n" && 
                view.LayoutLines[2] == "cc\n" && 
                view.LayoutLines[3] == "d"
                );

            doc.Remove(9, 1);
            Assert.IsTrue(
                view.LayoutLines[0] == "aa\n" &&
                view.LayoutLines[1] == "bb\n" &&
                view.LayoutLines[2] == "cc\n" &&
                view.LayoutLines[3] == ""
                );

            doc.Remove(0, 1);
            Assert.IsTrue(
                view.LayoutLines[0] == "a\n" &&
                view.LayoutLines[1] == "bb\n" &&
                view.LayoutLines[2] == "cc\n" &&
                view.LayoutLines[3] == ""
                );
        }

        [TestMethod]
        public void RemoveMultiLineTest()
        {
            Document doc = new Document();
            DummyRender render = new DummyRender();
            DummyView view = new DummyView(doc, render);

            doc.Clear();
            doc.Append("a\n");
            doc.Append("b\n");
            doc.Append("c\n");
            doc.Append("d\n");
            doc.Append("e\n");
            doc.Append("f\n");

            doc.Remove(2, 4);
            Assert.IsTrue(
                view.LayoutLines[0] == "a\n" &&
                view.LayoutLines[1] == "d\n" &&
                view.LayoutLines[2] == "e\n" &&
                view.LayoutLines[3] == "f\n");

            doc.Remove(4, 4);
            Assert.IsTrue(
                view.LayoutLines[0] == "a\n" &&
                view.LayoutLines[1] == "d\n");

            doc.Clear();
            doc.Append("a\n");
            doc.Append("b\n");
            doc.Append("c\n");
            doc.Append("d\n");

            doc.Remove(2, 6);
            Assert.IsTrue(view.LayoutLines[0] == "a\n");

            doc.Clear();
            doc.Append("a\n");
            doc.Append("b\n");
            doc.Append("c\n");
            doc.Append("d\n");
            doc.Append("e\n");
            doc.Append("f\n");
            doc.Insert(4, "a");
            doc.Remove(2, 5);
            Assert.IsTrue(
                view.LayoutLines[0] == "a\n" &&
                view.LayoutLines[1] == "d\n" &&
                view.LayoutLines[2] == "e\n" &&
                view.LayoutLines[3] == "f\n");
        }

        [TestMethod]
        public void QueryTest()
        {
            Document doc = new Document();
            DummyRender render = new DummyRender();
            DummyView view = new DummyView(doc, render);
            doc.Clear();
            doc.Append("a\nb\nc");

            Assert.IsTrue(view.LayoutLines.GetIndexFromLineNumber(1) == 2);
            Assert.IsTrue(view.LayoutLines.GetLengthFromLineNumber(1) == 2);
            Assert.IsTrue(view.LayoutLines.GetLineNumberFromIndex(2) == 1);
            TextPoint tp = view.LayoutLines.GetTextPointFromIndex(2);
            Assert.IsTrue(tp.row == 1 && tp.col == 0);
            Assert.IsTrue(view.LayoutLines.GetIndexFromTextPoint(tp) == 2);

            doc.Insert(2, "a");

            Assert.IsTrue(view.LayoutLines.GetIndexFromLineNumber(2) == 5);
            Assert.IsTrue(view.LayoutLines.GetLineNumberFromIndex(5) == 2);
            tp = view.LayoutLines.GetTextPointFromIndex(5);
            Assert.IsTrue(tp.row == 2 && tp.col == 0);
            Assert.IsTrue(view.LayoutLines.GetIndexFromTextPoint(tp) == 5);

            doc.Insert(0, "a");

            Assert.IsTrue(view.LayoutLines.GetIndexFromLineNumber(2) == 6);
            Assert.IsTrue(view.LayoutLines.GetLineNumberFromIndex(6) == 2);
            tp = view.LayoutLines.GetTextPointFromIndex(6);
            Assert.IsTrue(tp.row == 2 && tp.col == 0);
            Assert.IsTrue(view.LayoutLines.GetIndexFromTextPoint(tp) == 6);
        }
    }
}
