﻿/*
 * Copyright (C) 2013 FooProject
 * * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FooEditEngine
{
    enum GripperType
    {
        First,
        Second,
    }
    class Gripper : IEquatable<Gripper>
    {
        Controller Controller;
        EditView View;
        D2DRender Render;
        GripperType type;
        public Gripper(Controller controller, EditView view,D2DRender render,GripperType type)
        {
            this.Controller = controller;
            this.View = view;
            this.Render = render;
            this.Enabled = false;
            this.type = type;
        }
        public bool Enabled
        {
            get;
            set;
        }
        public Rectangle Rectangle
        {
            get
            {
                return this.GetGripperPoint(this.type);
            }
        }
        public bool IsHit(Point p)
        {
            Rectangle gripperRect = this.GetGripperPoint(type);
            return this.Enabled && gripperRect.IsHit(p);
        }

        public Point AdjustPoint(Point p)
        {
            if (this.type == GripperType.First)
            {
                if (this.Rectangle.IsHit(p))
                    p.Y = this.Rectangle.Bottom + 1;
                else
                    p.Y += this.Rectangle.Height;
            }
            else
            {
                if (this.Rectangle.IsHit(p))
                    p.Y = this.Rectangle.Y - 1;
                else
                    p.Y -= this.Rectangle.Height;
            }
            if (p.Y < this.Render.TextArea.Y)
                p.Y = this.Render.TextArea.Y;
            return p;
        }

        public void Draw()
        {
            if(this.Enabled)
                this.DrawGripper(this.type);
        }

        void DrawGripper(GripperType type)
        {
            Rectangle gripperRect = GetGripperPoint(type);
            double radius = gripperRect.Width / 2;
            Point point;
            if (type == GripperType.First)
                point = new Point(gripperRect.X + radius, gripperRect.Y + radius);
            else
                point = new Point(gripperRect.X + radius, gripperRect.Y + radius);
            this.Render.DrawGripper(point, radius);
        }

        Rectangle GetGripperPoint(GripperType type)
        {
            TextPoint tp;
            Point point;
            double radius = D2DRender.GripperWidth / 2;
            if (type == GripperType.Second)
            {
                tp = this.View.LayoutLines.GetTextPointFromIndex(this.Controller.SelectionStart + this.Controller.SelectionLength);
                point = this.View.GetPostionFromTextPoint(tp);
                double lineHeight = this.View.LayoutLines.GetLayout(tp.row).Height;
                return new Rectangle(point.X - radius, point.Y + lineHeight, D2DRender.GripperWidth, D2DRender.GripperWidth);
            }
            else if (type == GripperType.First)
            {
                tp = this.View.LayoutLines.GetTextPointFromIndex(this.Controller.SelectionStart);
                point = this.View.GetPostionFromTextPoint(tp);
                return new Rectangle(point.X - radius, point.Y - D2DRender.GripperWidth, D2DRender.GripperWidth, D2DRender.GripperWidth);
            }
            else
            {
                throw new ArgumentOutOfRangeException();
            }
        }

        public bool Equals(Gripper other)
        {
            return this.Rectangle == other.Rectangle;
        }
    }
}
