/*
  DefineSprite parser
*/
goog.provide('FlappSWFTagDefineSprite');

goog.scope(function() {

/**
 * @constructor
 */
FlappSWFTagDefineSprite = function(code, length, ibit) {
//    console.debug("FlappSWFTagDefineSprite(code:"+code+", length:"+length+", ibit)");
    this.code = code;
    this.length = length;
    //
    this.id = ibit.ui16();
    this.count = ibit.ui16();
    var controlTags = [];
    while (ibit.a(), ibit.hasNext(2)) {
        var headPos = ibit.getBytePos();
        var tag_and_length = ibit.ui16(); // tag and length
        var c = tag_and_length >>> 6;
	if (c === 0) { // End Tag
	    break;
	}
        var l = tag_and_length & 0x3f;
        if (l === 0x3f) {
            l = ibit.ui32();
        }
        var startOfContent = ibit.getBytePos();
        var tag = FlappSWFTag.load(c, l, ibit);
	controlTags.push(tag);
        ibit.setPos(startOfContent + l, 0);
    }
    this.controlTags = controlTags;
}

});
